/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cache.annotation.tag.Cache;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.mg.converter.MgRnrCommonConfigConverter;
import com.cusc.nirvana.user.rnr.mg.dao.MgRnrCommonConfigDao;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrCommonConfigPO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCommonConfigDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCommonConfigService;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MgRnrCommonConfigServiceImpl
extends ServiceImpl<MgRnrCommonConfigDao, MgRnrCommonConfigPO>
implements IMgRnrCommonConfigService {
    public MgRnrCommonConfigDTO getByUuid(MgRnrCommonConfigDTO bean) {
        MgRnrCommonConfigPO record = this.getPoByUuid(bean.getUuid());
        return MgRnrCommonConfigConverter.INSTANCE.poToDto(record);
    }

    public List<MgRnrCommonConfigDTO> queryByList(MgRnrCommonConfigDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return MgRnrCommonConfigConverter.INSTANCE.poListToDtoList(record);
    }

    @Transactional
    @Cache(keyPrefix="CT:RNR:COMMON:CONFIG:", key="#bean.configPath", level1="redis", action=0)
    public MgRnrCommonConfigDTO insert(MgRnrCommonConfigDTO bean) {
        MgRnrCommonConfigPO mgRnrCommonConfigPO = MgRnrCommonConfigConverter.INSTANCE.dtoToPo(bean);
        this.save((Object)mgRnrCommonConfigPO);
        return bean;
    }

    @Transactional
    @Cache(keyPrefix="CT:RNR:COMMON:CONFIG:", key="#bean.configPath", level1="redis", action=0)
    public MgRnrCommonConfigDTO update(MgRnrCommonConfigDTO bean) {
        MgRnrCommonConfigPO mgRnrCommonConfigPO = this.getPoByUuid(bean.getUuid());
        if (mgRnrCommonConfigPO == null) {
            return null;
        }
        MgRnrCommonConfigPO tmpBean = MgRnrCommonConfigConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(mgRnrCommonConfigPO.getId());
        this.updateById((Object)tmpBean);
        return bean;
    }

    @Transactional
    @Cache(keyPrefix="CT:RNR:COMMON:CONFIG:", key="#bean.configPath", level1="redis", action=0)
    public boolean deleteById(MgRnrCommonConfigDTO bean) {
        MgRnrCommonConfigPO mgRnrCommonConfigPO = this.getPoByUuid(bean.getUuid());
        if (mgRnrCommonConfigPO == null) {
            return false;
        }
        MgRnrCommonConfigPO tmpBean = new MgRnrCommonConfigPO();
        tmpBean.setId(mgRnrCommonConfigPO.getId());
        tmpBean.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        return this.updateById((Object)tmpBean);
    }

    @Cache(keyPrefix="CT:RNR:COMMON:CONFIG:", key="#path", level1="redis")
    public MgRnrCommonConfigDTO getByConfigPath(String path) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_path", (Object)path);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        MgRnrCommonConfigPO record = (MgRnrCommonConfigPO)this.getOne((Wrapper)queryWrapper);
        return MgRnrCommonConfigConverter.INSTANCE.poToDto(record);
    }

    public List<MgRnrCommonConfigDTO> getByConfigParentPath(String parentPath) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"parent_path", (Object)parentPath);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByAsc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return MgRnrCommonConfigConverter.INSTANCE.poListToDtoList(record);
    }

    private MgRnrCommonConfigPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (MgRnrCommonConfigPO)this.getOne((Wrapper)queryWrapper);
    }
}

