/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.cache.CacheFactory;
import com.cache.exception.CacheException;
import com.cusc.nirvana.user.rnr.mg.constants.NoticeStatusEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrBizzTypeEnum;
import com.cusc.nirvana.user.rnr.mg.converter.MgRnrCardInfoConverter;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrCardInfoPO;
import com.cusc.nirvana.user.rnr.mg.dto.MgCardNoticeDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardNoticeService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrOrderService;
import com.cusc.nirvana.user.rnr.mg.util.RnrOrderUtil;
import com.cusc.nirvana.user.rnr.notice.kafka.KafkaProduct;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@EnableScheduling
public class MgRnrCardNoticeServiceImpl
implements IMgRnrCardNoticeService {
    private static final Logger log = LoggerFactory.getLogger(MgRnrCardNoticeServiceImpl.class);
    @Autowired
    IMgRnrCardInfoService cardInfoService;
    @Autowired
    IRnrOrderService orderService;
    @Resource
    private CacheFactory cacheFactory;
    @Autowired
    private KafkaProduct kafkaProduct;
    @Value(value="${mg.rnr.mq.lock.expireTime:6000}")
    private int expireTime;

    @Scheduled(fixedDelayString="${mg.rnr.mq.interval:50000}")
    public void sendCardNotices() {
        log.info("MgRnrCardNoticeServiceImpl sendCardNotices start... ");
        Iterator it = this.findNoticeCards();
        while (it.hasNext()) {
            MgRnrCardInfoPO cardInfoPO = (MgRnrCardInfoPO)it.next();
            RnrOrderDTO rnrOrderDTO = new RnrOrderDTO();
            rnrOrderDTO.setUuid(cardInfoPO.getOrderId());
            rnrOrderDTO = this.orderService.getByUuid(rnrOrderDTO);
            this.sendCardNotice(this.convertToNotice(cardInfoPO, RnrOrderUtil.orderTypeToNoticeType((int)rnrOrderDTO.getOrderType())));
        }
    }

    @Async(value="mqExecutor")
    public void sendCardNotice(List<MgCardNoticeDTO> dtos) {
        for (MgCardNoticeDTO dto : dtos) {
            this.sendCardNotice(dto);
        }
    }

    public void sendCardNoticeByOrderId(String orderId) {
        RnrOrderDTO rnrOrderDTO = new RnrOrderDTO();
        rnrOrderDTO.setUuid(orderId);
        rnrOrderDTO = this.orderService.getByUuid(rnrOrderDTO);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_id", (Object)orderId);
        List list = this.cardInfoService.list((Wrapper)queryWrapper);
        ArrayList<MgCardNoticeDTO> dtos = new ArrayList<MgCardNoticeDTO>();
        for (MgRnrCardInfoPO cardInfo : list) {
            MgCardNoticeDTO mgCardNoticeDTO = this.convertToNotice(cardInfo, RnrOrderUtil.orderTypeToNoticeType((int)rnrOrderDTO.getOrderType()));
            if (mgCardNoticeDTO == null) continue;
            dtos.add(mgCardNoticeDTO);
        }
        this.sendCardNotice(dtos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCardNotice(MgCardNoticeDTO dto) {
        String lockKey = "CT:RNR:CARD:NOTICE:" + dto.getOrderId() + ":" + dto.getIccid();
        try {
            Boolean lock = this.cacheFactory.getLockService().lock(lockKey, this.expireTime);
            if (!lock.booleanValue()) {
                return;
            }
            MgRnrCardInfoDTO mgRnrCardInfoDTO = this.cardInfoService.getByOrderIdAndIccId(dto.getOrderId(), dto.getIccid());
            if (mgRnrCardInfoDTO != null) {
                this.kafkaProduct.sendMessage("cusc-rnr-card-operation-topic", JSON.toJSONString((Object)dto));
                mgRnrCardInfoDTO.setNoticeStatus(Integer.valueOf(NoticeStatusEnum.SUCCESS.getCode()));
                this.cardInfoService.updateCardNoticeStatus(mgRnrCardInfoDTO);
                log.info("\u53d1\u9001\u5b9e\u540dmq\u6d88\u606f\u6210\u529f:{}", (Object)JSON.toJSONString((Object)dto));
            }
        }
        catch (Exception e) {
            log.error("RetryUploadInfo failed, card notice: " + dto.getOrderId() + ":" + dto.getIccid(), (Throwable)e);
        }
        finally {
            try {
                this.cacheFactory.getLockService().unLock(lockKey);
            }
            catch (CacheException e) {
                log.error("Failed to unlock " + lockKey, (Throwable)e);
            }
        }
    }

    private MgCardNoticeDTO convertToNotice(MgRnrCardInfoPO cardInfo, RnrBizzTypeEnum rnrNoticeTypeEnum) {
        MgCardNoticeDTO mqDTO = MgRnrCardInfoConverter.INSTANCE.poToNoticeDTO(cardInfo);
        mqDTO.setVin(cardInfo.getIotId());
        mqDTO.setRnrBizzType(rnrNoticeTypeEnum.getCode().intValue());
        mqDTO.setOrderId(cardInfo.getOrderId());
        return mqDTO;
    }

    private Iterator<MgRnrCardInfoPO> findNoticeCards() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Page<MgRnrCardInfoPO> findNexPage(int page) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.ne((Object)"notice_status", (Object)NoticeStatusEnum.SUCCESS.getCode());
        queryWrapper.and(wrapper -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)wrapper.ne((Object)"notice_status", (Object)NoticeStatusEnum.NONEED.getCode());
        });
        queryWrapper.orderByAsc((Object)"create_time");
        return (Page)this.cardInfoService.page((IPage)new Page((long)page, 100L), (Wrapper)queryWrapper);
    }

    static /* synthetic */ Page access$000(MgRnrCardNoticeServiceImpl x0, int x1) {
        return x0.findNexPage(x1);
    }
}

