/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.mg.constants.CryptKeyHelper;
import com.cusc.nirvana.user.rnr.mg.constants.MbCodeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrBizzTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrStatus;
import com.cusc.nirvana.user.rnr.mg.converter.MgRnrCardInfoConverter;
import com.cusc.nirvana.user.rnr.mg.dao.MgRnrCardInfoDao;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrCardInfoPO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardNoticeService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MgRnrCardInfoServiceImpl
extends ServiceImpl<MgRnrCardInfoDao, MgRnrCardInfoPO>
implements IMgRnrCardInfoService {
    private static final Logger log = LoggerFactory.getLogger(MgRnrCardInfoServiceImpl.class);
    @Resource
    @Lazy
    private IMgRnrCardNoticeService cardNoticeService;

    public MgRnrCardInfoDTO getByUuid(MgRnrCardInfoDTO bean) {
        MgRnrCardInfoPO record = this.getPoByUuid(bean.getUuid());
        return MgRnrCardInfoConverter.INSTANCE.poToDto(record);
    }

    public List<MgRnrCardInfoDTO> queryByList(MgRnrCardInfoDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)bean.getRnrId()), (Object)"rnr_id", (Object)bean.getRnrId());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)bean.getTenantNo()), (Object)"tenant_no", (Object)bean.getTenantNo());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)bean.getIccid()), (Object)"iccid", (Object)CryptKeyHelper.encrypt((String)bean.getIccid()));
        queryWrapper.eq(null != bean.getRnrStatus(), (Object)"rnr_status", (Object)bean.getRnrStatus());
        queryWrapper.eq(null != bean.getRnrBizzType(), (Object)"rnr_bizz_type", (Object)bean.getRnrBizzType());
        queryWrapper.eq(null != bean.getOrderId(), (Object)"order_id", (Object)bean.getOrderId());
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)bean.getIotId()), (Object)"iot_id", (Object)CryptKeyHelper.encrypt((String)bean.getIotId()));
        queryWrapper.in(!CollectionUtils.isEmpty((Collection)bean.getRnrIdList()), (Object)"rnr_id", (Collection)bean.getRnrIdList());
        queryWrapper.in(!CollectionUtils.isEmpty((Collection)bean.getBizTypeList()), (Object)"rnr_bizz_type", (Collection)bean.getBizTypeList());
        queryWrapper.in(!CollectionUtils.isEmpty((Collection)bean.getIccidList()), (Object)"iccid", (Collection)CryptKeyHelper.encrypt((List)bean.getIccidList()));
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return MgRnrCardInfoConverter.INSTANCE.poListToDtoList(record);
    }

    public PageResult<MgRnrCardInfoDTO> queryByPage(MgRnrCardInfoDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(null != bean.getOrderId(), (Object)"order_id", (Object)bean.getOrderId());
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        Page page = (Page)this.page((IPage)new Page((long)bean.getCurrPage().intValue(), (long)bean.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, MgRnrCardInfoDTO.class);
    }

    @Transactional
    public MgRnrCardInfoDTO insert(MgRnrCardInfoDTO bean) {
        MgRnrCardInfoPO mgRnrCardInfoPO = MgRnrCardInfoConverter.INSTANCE.dtoToPo(bean);
        if (CuscStringUtils.isEmpty((String)bean.getUuid())) {
            mgRnrCardInfoPO.setUuid(CuscStringUtils.generateUuid());
            bean.setUuid(mgRnrCardInfoPO.getUuid());
        }
        this.save((Object)mgRnrCardInfoPO);
        return bean;
    }

    @Transactional
    public MgRnrCardInfoDTO update(MgRnrCardInfoDTO bean) {
        MgRnrCardInfoPO mgRnrCardInfoPO = this.getPoByUuid(bean.getUuid());
        if (mgRnrCardInfoPO == null) {
            return null;
        }
        MgRnrCardInfoPO tmpBean = MgRnrCardInfoConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(mgRnrCardInfoPO.getId());
        this.updateById((Object)tmpBean);
        return bean;
    }

    @Transactional
    public boolean deleteById(MgRnrCardInfoDTO bean) {
        MgRnrCardInfoPO mgRnrCardInfoPO = this.getPoByUuid(bean.getUuid());
        if (mgRnrCardInfoPO == null) {
            return false;
        }
        MgRnrCardInfoPO tmpBean = new MgRnrCardInfoPO();
        tmpBean.setId(mgRnrCardInfoPO.getId());
        tmpBean.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        return this.updateById((Object)tmpBean);
    }

    public Integer addRnrCardBatch(List<MgRnrCardInfoPO> beanList) {
        beanList.forEach(bean -> {
            if (null == bean.getOldCardId()) {
                bean.setOldCardId("");
            }
            bean.setIccid(CryptKeyHelper.encrypt((String)bean.getIccid()));
            bean.setIotId(CryptKeyHelper.encrypt((String)bean.getIotId()));
        });
        return ((MgRnrCardInfoDao)this.baseMapper).addRnrCardBatch(beanList);
    }

    public List<MgRnrCardInfoDTO> getByIccid(MgRnrCardInfoDTO bean) {
        return null;
    }

    public List<MgRnrCardInfoDTO> getListByIccid(MgRnrCardInfoDTO bean) {
        List oneByIccid = this.getListByIccid(bean.getIccid());
        return MgRnrCardInfoConverter.INSTANCE.poListToDtoList(oneByIccid);
    }

    public MgRnrCardInfoDTO getOneByIccid(MgRnrCardInfoDTO bean) {
        MgRnrCardInfoPO oneCardByIccid = this.getOneCardByIccid(bean.getIccid(), bean.getIotId(), bean.getTenantNo());
        return MgRnrCardInfoConverter.INSTANCE.poToDto(oneCardByIccid);
    }

    public MgRnrCardInfoDTO getByOrderIdAndIccId(String orderId, String iccid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_id", (Object)orderId);
        queryWrapper.eq((Object)"iccid", (Object)CryptKeyHelper.encrypt((String)iccid));
        List list = this.list((Wrapper)queryWrapper);
        return list.isEmpty() ? null : MgRnrCardInfoConverter.INSTANCE.poToDto((MgRnrCardInfoPO)list.get(0));
    }

    public Integer updateCardNoticeStatus(MgRnrCardInfoDTO mgRnrCardInfoDTO) {
        return ((MgRnrCardInfoDao)this.baseMapper).updateCardNoticeStatus(mgRnrCardInfoDTO);
    }

    public Integer updateCardStatusByOrderId(String orderId, int noticeStatus, int rnrStatus) {
        return ((MgRnrCardInfoDao)this.baseMapper).updateCardStatusByOrderId(orderId, noticeStatus, rnrStatus);
    }

    public boolean checkIccidExists(MgRnrCardInfoDTO bean) {
        boolean ret = false;
        List cardList = this.getByIccid(bean);
        if (CollectionUtils.isEmpty((Collection)cardList)) {
            return ret;
        }
        for (MgRnrCardInfoDTO card : cardList) {
            if (1 != card.getRnrStatus() && 2 != card.getRnrStatus() && 6 != card.getRnrStatus()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean checkIccid(MgRnrCardInfoDTO bean) {
        boolean ret = false;
        List cardList = this.getListByIccid(bean);
        if (CollectionUtils.isEmpty((Collection)cardList)) {
            return ret;
        }
        for (MgRnrCardInfoDTO card : cardList) {
            if (5 != card.getRnrStatus()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public List<MgRnrCardInfoDTO> queryBindListByVin(String vin) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq((Object)"rnr_status", (Object)RnrStatus.RNR.getCode());
        queryWrapper.eq((Object)"iot_id", (Object)CryptKeyHelper.encrypt((String)vin));
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return MgRnrCardInfoConverter.INSTANCE.poListToDtoList(record);
    }

    public List<MgRnrCardInfoDTO> queryBindListByVinsAndIccids(List<String> vins, List<String> iccids) {
        ArrayList encryptVins = new ArrayList();
        if (!CollectionUtils.isEmpty(vins)) {
            vins.forEach(vin -> encryptVins.add(CryptKeyHelper.encrypt((String)vin)));
        }
        ArrayList encryptIccids = new ArrayList();
        if (!CollectionUtils.isEmpty(iccids)) {
            iccids.forEach(iccid -> encryptIccids.add(CryptKeyHelper.encrypt((String)iccid)));
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.in((Object)"rnr_status", Arrays.asList(RnrStatus.RNR.getCode(), RnrStatus.INIT.getCode()));
        queryWrapper.in((Object)"iot_id", encryptVins);
        queryWrapper.in(!CollectionUtils.isEmpty(encryptIccids), (Object)"iccid", encryptIccids);
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return MgRnrCardInfoConverter.INSTANCE.poListToDtoList(record);
    }

    public List<MgRnrCardInfoDTO> queryBindListByVinAndBizType(String vin, int bizTpye) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq((Object)"rnr_status", (Object)RnrStatus.RNR.getCode());
        queryWrapper.eq((Object)"iot_id", (Object)CryptKeyHelper.encrypt((String)vin));
        queryWrapper.eq((Object)"rnr_bizz_type", (Object)bizTpye);
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return MgRnrCardInfoConverter.INSTANCE.poListToDtoList(record);
    }

    public List<MgRnrCardInfoDTO> queryListByVin(String vin) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq((Object)"iot_id", (Object)CryptKeyHelper.encrypt((String)vin));
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return MgRnrCardInfoConverter.INSTANCE.poListToDtoList(record);
    }

    public Integer unboundCardBatch(List<String> uuids, RnrStatus status) {
        return ((MgRnrCardInfoDao)this.baseMapper).unboundCardBatch(uuids, status.getCode());
    }

    public Integer updateBatchCardStatus(List<MgRnrCardInfoDTO> beans) {
        ArrayList<String> uuidList = new ArrayList<String>();
        for (MgRnrCardInfoDTO cardInfoDTO : beans) {
            uuidList.add(cardInfoDTO.getUuid());
        }
        return this.unboundCardBatch(uuidList, RnrStatus.UNBOUND);
    }

    public Integer insertBatchCards(List<MgRnrCardInfoDTO> beans) {
        MgRnrCardInfoDTO cardInfoDTO;
        MgRnrCardInfoDTO insert;
        int target = 0;
        ArrayList uuidList = new ArrayList();
        Iterator<MgRnrCardInfoDTO> iterator = beans.iterator();
        while (iterator.hasNext() && (insert = this.insert(cardInfoDTO = iterator.next())) != null) {
            ++target;
        }
        return target;
    }

    public void updateCardStatusByRnrId(MgRnrCardInfoDTO dto) {
        MgRnrCardInfoPO updateEntity = new MgRnrCardInfoPO();
        updateEntity.setRnrStatus(dto.getRnrStatus());
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(MgRnrCardInfoPO::getRnrId, (Object)dto.getRnrId());
        ((MgRnrCardInfoDao)this.baseMapper).update((Object)updateEntity, (Wrapper)query);
    }

    public void sendCardNotice(MgRnrCardInfoDTO dto) {
        if (StringUtils.isBlank((CharSequence)dto.getOrderId())) {
            return;
        }
        this.cardNoticeService.sendCardNoticeByOrderId(dto.getOrderId());
    }

    public PageResult<MgRnrCardInfoDTO> queryPageByUserId(MgRnrCardInfoDTO bean) {
        Page page = new Page((long)bean.getCurrPage().intValue(), (long)bean.getPageSize().intValue());
        page.setRecords(((MgRnrCardInfoDao)this.baseMapper).queryByUserId(page, bean));
        return PageHelper.convert((Page)page, MgRnrCardInfoDTO.class);
    }

    public MgRnrCardInfoDTO getNewRnrCardByIccid(MgRnrCardInfoDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.ne((Object)"rnr_bizz_type", (Object)RnrBizzTypeEnum.Unbound.getCode());
        queryWrapper.eq((Object)"iccid", (Object)CryptKeyHelper.encrypt((String)bean.getIccid()));
        queryWrapper.eq((Object)"tenant_no", (Object)bean.getTenantNo());
        queryWrapper.eq((Object)"rnr_status", (Object)RnrStatus.RNR.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)record)) {
            return null;
        }
        return MgRnrCardInfoConverter.INSTANCE.poToDto((MgRnrCardInfoPO)record.get(0));
    }

    public int getNumWithUnload(MgRnrInfoDTO dto) {
        int num = 0;
        String certNumber = CryptKeyHelper.encrypt((String)dto.getCertNumber());
        List retList = ((MgRnrCardInfoDao)this.baseMapper).getNumWithUnload(certNumber);
        for (String iccid : retList) {
            iccid = CryptKeyHelper.decrypt((String)iccid);
            MbCodeEnum mbCodeEnum = MbCodeEnum.get((String)iccid);
            log.info("\u89e3\u5bc6\u4e4b\u540e\u662f,{},\u901a\u8baf\u5546\u662f,{},\u524d6\u4f4d\u662f,{}", new Object[]{iccid, mbCodeEnum.getName(), iccid.substring(0, 6)});
            if (!MbCodeEnum.CUCC.equals((Object)mbCodeEnum)) continue;
            ++num;
        }
        return num;
    }

    private MgRnrCardInfoPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (MgRnrCardInfoPO)this.getOne((Wrapper)queryWrapper);
    }

    private List<MgRnrCardInfoPO> getListByIccid(String iccid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"iccid", (Object)CryptKeyHelper.encrypt((String)iccid));
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return this.list((Wrapper)queryWrapper);
    }

    private MgRnrCardInfoPO getOneCardByIccid(String iccid, String vin, String tenantNo) {
        List retList;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"iccid", (Object)CryptKeyHelper.encrypt((String)iccid));
        queryWrapper.ne((Object)"rnr_bizz_type", (Object)RnrBizzTypeEnum.Unbound.getCode());
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq((Object)"rnr_status", (Object)RnrStatus.RNR.getCode());
        queryWrapper.eq((Object)"tenant_no", (Object)tenantNo);
        if (StringUtils.isNotEmpty((CharSequence)vin)) {
            queryWrapper.eq((Object)"iot_id", (Object)CryptKeyHelper.encrypt((String)vin));
        }
        if (!CollectionUtils.isEmpty((Collection)(retList = this.list((Wrapper)queryWrapper)))) {
            return (MgRnrCardInfoPO)retList.get(0);
        }
        return null;
    }

    public List<MgRnrCardInfoDTO> getByRnrid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq((Object)"rnr_id", (Object)uuid);
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return MgRnrCardInfoConverter.INSTANCE.poListToDtoList(record);
    }
}

