/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.cache.CacheFactory;
import com.cache.exception.CacheException;
import com.cusc.nirvana.common.loader.CollectionUtils;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.rnr.mg.constants.CommonYesOrNoEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrBizzTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrStatus;
import com.cusc.nirvana.user.rnr.mg.dao.MgCheckProgressDao;
import com.cusc.nirvana.user.rnr.mg.dto.MgCheckProgressDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgCheckStatisticsDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgCheckStatisticsQueryDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgCheckProgressService;
import com.cusc.nirvana.user.util.DateUtils;
import com.cusc.nirvana.user.util.crypt.CryptKeyUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MgCheckProgressServiceImpl
implements IMgCheckProgressService {
    private static final Logger log = LoggerFactory.getLogger(MgCheckProgressServiceImpl.class);
    @Resource
    private MgCheckProgressDao mgCheckProgressDao;
    @Resource
    private CacheFactory cacheFactory;
    private static final Integer MAX_NUMBER = 500;

    public PageResult<MgCheckProgressDTO> queryByPage(MgCheckProgressDTO bean) {
        bean.setFullName(CryptKeyUtil.encryptToBase64((String)bean.getFullName()));
        bean.setPhone(CryptKeyUtil.encryptToBase64((String)bean.getPhone()));
        bean.setIotId(CryptKeyUtil.encryptToBase64((String)bean.getIotId()));
        bean.setIccid(CryptKeyUtil.encryptToBase64((String)bean.getIccid()));
        bean.setCompanyName(CryptKeyUtil.encryptToBase64((String)bean.getCompanyName()));
        Page page = new Page((long)bean.getCurrPage().intValue(), (long)bean.getPageSize().intValue());
        page.setRecords(this.mgCheckProgressDao.queryCheckProgressByPage(page, bean));
        return PageHelper.convert((Page)page, MgCheckProgressDTO.class);
    }

    public MgCheckStatisticsDTO queryCheckStatistics(MgCheckStatisticsQueryDTO queryDTO) {
        String cachedValue = this.getCachedStatisticsValue(queryDTO);
        if (StringUtils.isNotBlank((CharSequence)cachedValue)) {
            return (MgCheckStatisticsDTO)JSON.parseObject((String)cachedValue, MgCheckStatisticsDTO.class);
        }
        List subList = this.subList(queryDTO.getOrgIdList());
        MgCheckStatisticsQueryDTO queryPeopleDTO = this.initQueryParam(Integer.valueOf(CommonYesOrNoEnum.NO.getCode()), queryDTO.getTenantNo());
        MgCheckStatisticsQueryDTO queryCompanyDTO = this.initQueryParam(Integer.valueOf(CommonYesOrNoEnum.YES.getCode()), queryDTO.getTenantNo());
        ArrayList<Integer> rnrStatusAllList = new ArrayList<Integer>();
        rnrStatusAllList.add(RnrStatus.RNR.getCode());
        rnrStatusAllList.add(RnrStatus.RNR_FAIL.getCode());
        rnrStatusAllList.add(RnrStatus.UNBOUND.getCode());
        MgCheckStatisticsQueryDTO allParam = this.initVehicleQueryParam(rnrStatusAllList);
        allParam.setTenantNo(queryDTO.getTenantNo());
        ArrayList<Integer> rnrStatusSuccessList = new ArrayList<Integer>();
        rnrStatusSuccessList.add(RnrStatus.RNR.getCode());
        rnrStatusSuccessList.add(RnrStatus.UNBOUND.getCode());
        MgCheckStatisticsQueryDTO successParam = this.initVehicleQueryParam(rnrStatusSuccessList);
        successParam.setTenantNo(queryDTO.getTenantNo());
        Integer peopleRnrNumTotal = 0;
        Integer companyRnrNumTotal = 0;
        Integer allNumTotal = 0;
        Integer successNumTotal = 0;
        for (List orgIdList : subList) {
            queryPeopleDTO.setOrgIdList(orgIdList);
            Integer peopleRnrNum = this.mgCheckProgressDao.queryStatisticsCountByCondition(queryPeopleDTO);
            peopleRnrNumTotal = peopleRnrNumTotal + peopleRnrNum;
            queryCompanyDTO.setOrgIdList(orgIdList);
            Integer companyRnrNum = this.mgCheckProgressDao.queryStatisticsCountByCondition(queryCompanyDTO);
            companyRnrNumTotal = companyRnrNumTotal + companyRnrNum;
            allParam.setOrgIdList(orgIdList);
            Integer allNum = this.mgCheckProgressDao.queryStatisticsCountByCondition(allParam);
            allNumTotal = allNumTotal + allNum;
            successParam.setOrgIdList(orgIdList);
            Integer successNum = this.mgCheckProgressDao.queryStatisticsCountByCondition(successParam);
            successNumTotal = successNumTotal + successNum;
        }
        String rate = allNumTotal == 0 || successNumTotal == 0 ? "\u6682\u65e0\u8f66\u4f01\u6570\u636e" : MgCheckProgressServiceImpl.calculatePercent((Integer)successNumTotal, (Integer)allNumTotal);
        String vehicleHandleTimeAvg = this.getVehicleHandleTimeAvg(queryDTO, subList);
        MgCheckStatisticsDTO result = new MgCheckStatisticsDTO();
        result.setPeopleRnrNum(peopleRnrNumTotal);
        result.setCompanyRnrNum(companyRnrNumTotal);
        result.setVehicleCompanyRnrSuccessRate(rate);
        result.setVehicleHandleTimeAvg(vehicleHandleTimeAvg);
        this.setCachedStatisticsValue(result, queryDTO);
        return result;
    }

    public String getCachedStatisticsValue(MgCheckStatisticsQueryDTO queryDTO) {
        String key = "CT:RNR:CARD_STATISTICS:KEY:" + queryDTO.getTenantNo() + queryDTO.getUserOrgId() + MgCheckProgressServiceImpl.initDate();
        String valueStr = null;
        try {
            valueStr = (String)this.cacheFactory.getStringService().getValue(key, String.class);
        }
        catch (CacheException e) {
            log.error("MgCheckProgressServiceImpl.getCachedCheckStatistics \u83b7\u53d6\u7f13\u5b58\u5931\u8d25,key = {}", (Object)key, (Object)e);
        }
        return valueStr;
    }

    public void setCachedStatisticsValue(MgCheckStatisticsDTO result, MgCheckStatisticsQueryDTO queryDTO) {
        String key = "CT:RNR:CARD_STATISTICS:KEY:" + queryDTO.getTenantNo() + queryDTO.getUserOrgId() + MgCheckProgressServiceImpl.initDate();
        try {
            this.cacheFactory.getExpireStringService().setExpireValue(key, (Object)JSON.toJSONString((Object)result), 86400);
        }
        catch (CacheException e) {
            log.error("MgCheckProgressServiceImpl.setCachedValue \u52a0\u5165\u7f13\u5b58\u5931\u8d25,key = {}", (Object)key, (Object)e);
        }
    }

    private String getVehicleHandleTimeAvg(MgCheckStatisticsQueryDTO queryDTO, List<List<String>> subList) {
        MgCheckStatisticsQueryDTO param = new MgCheckStatisticsQueryDTO();
        param.setDateTime(MgCheckProgressServiceImpl.initDate());
        param.setTenantNo(queryDTO.getTenantNo());
        ArrayList<Integer> rnrBizzTypeList = new ArrayList<Integer>();
        rnrBizzTypeList.add(RnrBizzTypeEnum.Bind.getCode());
        rnrBizzTypeList.add(RnrBizzTypeEnum.Unbound.getCode());
        rnrBizzTypeList.add(RnrBizzTypeEnum.ChangeBinding.getCode());
        rnrBizzTypeList.add(RnrBizzTypeEnum.INFO_CHANGE.getCode());
        rnrBizzTypeList.add(RnrBizzTypeEnum.REPEAT_BIND.getCode());
        param.setRnrBizzTypeList(rnrBizzTypeList);
        param.setIsCompany(Integer.valueOf(CommonYesOrNoEnum.YES.getCode()));
        param.setIsVehicleCompany(Integer.valueOf(CommonYesOrNoEnum.YES.getCode()));
        ArrayList all = new ArrayList();
        for (List<String> orgIdList : subList) {
            param.setOrgIdList(orgIdList);
            List list = this.mgCheckProgressDao.queryVehicleCompanyHandleTime(param);
            all.addAll(list);
        }
        List collect = all.stream().filter(Objects::nonNull).collect(Collectors.toList());
        log.info("collect:" + collect);
        if (CollectionUtils.isEmpty(collect)) {
            return "\u6682\u65e0\u5e73\u5747\u5904\u7406\u65f6\u957f";
        }
        Double average = collect.stream().mapToDouble(Number::doubleValue).average().getAsDouble();
        String s = MgCheckProgressServiceImpl.secondToTime((long)average.longValue());
        log.info("average" + s);
        return s;
    }

    private static String secondToTime(long second) {
        long days = second / 86400L;
        long hours = (second %= 86400L) / 3600L;
        long minutes = (second %= 3600L) / 60L;
        second %= 60L;
        if (0L < days) {
            return days + ":" + hours + ":" + minutes + ":" + second;
        }
        return hours + ":" + minutes + ":" + second;
    }

    private Integer countStep(Integer size) {
        return (size + MAX_NUMBER - 1) / MAX_NUMBER;
    }

    private List<List<String>> subList(List<String> list) {
        int limit = this.countStep(Integer.valueOf(list.size()));
        ArrayList<List<String>> mglist = new ArrayList<List<String>>();
        if (CollectionUtils.isEmpty(list)) {
            return mglist;
        }
        Stream.iterate(0, n -> n + 1).limit(limit).forEach(i -> mglist.add(list.stream().skip(i * MAX_NUMBER).limit(MAX_NUMBER.intValue()).collect(Collectors.toList())));
        return mglist;
    }

    private MgCheckStatisticsQueryDTO initQueryParam(Integer isCompany, String tenantNo) {
        MgCheckStatisticsQueryDTO queryDTO = new MgCheckStatisticsQueryDTO();
        queryDTO.setDateTime(MgCheckProgressServiceImpl.initDate());
        queryDTO.setTenantNo(tenantNo);
        ArrayList<Integer> rnrBizzTypeList = new ArrayList<Integer>();
        rnrBizzTypeList.add(RnrBizzTypeEnum.Bind.getCode());
        queryDTO.setRnrBizzTypeList(rnrBizzTypeList);
        ArrayList<Integer> rnrStatusList = new ArrayList<Integer>();
        rnrStatusList.add(RnrStatus.RNR.getCode());
        rnrStatusList.add(RnrStatus.UNBOUND.getCode());
        queryDTO.setRnrStatusList(rnrStatusList);
        queryDTO.setIsCompany(isCompany);
        return queryDTO;
    }

    private MgCheckStatisticsQueryDTO initVehicleQueryParam(List<Integer> rnrStatusList) {
        MgCheckStatisticsQueryDTO queryDTO = new MgCheckStatisticsQueryDTO();
        queryDTO.setDateTime(MgCheckProgressServiceImpl.initDate());
        ArrayList<Integer> rnrBizzTypeList = new ArrayList<Integer>();
        rnrBizzTypeList.add(RnrBizzTypeEnum.Bind.getCode());
        queryDTO.setRnrBizzTypeList(rnrBizzTypeList);
        queryDTO.setRnrStatusList(rnrStatusList);
        queryDTO.setIsCompany(Integer.valueOf(CommonYesOrNoEnum.YES.getCode()));
        queryDTO.setIsVehicleCompany(Integer.valueOf(CommonYesOrNoEnum.YES.getCode()));
        return queryDTO;
    }

    public static String initDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return DateUtils.formatDatetime((Date)calendar.getTime());
    }

    public static String calculatePercent(Integer a, Integer b) {
        String percent = new BigDecimal((double)a.intValue() * 100.0 / (double)b.intValue()).setScale(0, 4) + "%";
        return percent;
    }
}

