/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.cusc.nirvana.common.loader.CollectionUtils;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.client.UserClient;
import com.cusc.nirvana.user.eiam.dto.UserDTO;
import com.cusc.nirvana.user.rnr.mg.constants.AuthWayTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.CertTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.GenderEnum;
import com.cusc.nirvana.user.rnr.mg.constants.PassCodeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrFileType;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOrderStatusEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOrderType;
import com.cusc.nirvana.user.rnr.mg.constants.RnrStatus;
import com.cusc.nirvana.user.rnr.mg.converter.MgRnrCompanyInfoConverter;
import com.cusc.nirvana.user.rnr.mg.converter.MgRnrImageConverter;
import com.cusc.nirvana.user.rnr.mg.converter.MgRnrInfoConverter;
import com.cusc.nirvana.user.rnr.mg.converter.MgRnrLiaisonInfoConverter;
import com.cusc.nirvana.user.rnr.mg.converter.RnrOrderConverter;
import com.cusc.nirvana.user.rnr.mg.dao.RnrOrderDao;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrCardInfoPO;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrCompanyInfoPO;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrFilePO;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrInfoPO;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrLiaisonInfoPO;
import com.cusc.nirvana.user.rnr.mg.dao.entity.RnrOrderPO;
import com.cusc.nirvana.user.rnr.mg.dto.EnterpriseVerifyDetailDTO;
import com.cusc.nirvana.user.rnr.mg.dto.LocalVerifyListDTO;
import com.cusc.nirvana.user.rnr.mg.dto.LocalVerifyListRqDTO;
import com.cusc.nirvana.user.rnr.mg.dto.LocalVerifyPersonDetailDTO;
import com.cusc.nirvana.user.rnr.mg.dto.LocalVerifySubmitRq;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrAuthenticationResultDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCompanyInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrLiaisonInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrRelationDTO;
import com.cusc.nirvana.user.rnr.mg.service.IFileService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrAuthenticationResultService;
import com.cusc.nirvana.user.rnr.mg.service.impl.MgRnrCardInfoServiceImpl;
import com.cusc.nirvana.user.rnr.mg.service.impl.MgRnrCompanyInfoServiceImpl;
import com.cusc.nirvana.user.rnr.mg.service.impl.MgRnrFileServiceImpl;
import com.cusc.nirvana.user.rnr.mg.service.impl.MgRnrInfoServiceImpl;
import com.cusc.nirvana.user.rnr.mg.service.impl.MgRnrLiaisonInfoServiceImpl;
import com.cusc.nirvana.user.rnr.mg.service.impl.NotifyCloudService;
import com.cusc.nirvana.user.rnr.mg.service.impl.RnrOrderServiceImpl;
import com.cusc.nirvana.user.rnr.mg.util.DateUtil;
import com.cusc.nirvana.user.rnr.workorder.constants.WorkOrderTypeEnum;
import com.cusc.nirvana.user.rnr.workorder.dto.WorkOrderReviewCallBackRequestDTO;
import com.cusc.nirvana.user.rnr.workorder.handler.impl.EnterpriseChangeCallBackHandler;
import com.cusc.nirvana.user.rnr.workorder.handler.impl.ManufacturerRnrCallBackHandler;
import com.cusc.nirvana.user.rnr.workorder.handler.impl.RnrWorkOrderCallBackHandler;
import com.cusc.nirvana.user.rnr.workorder.handler.impl.UnbindWorkOrderCallBackHandler;
import com.cusc.nirvana.user.util.CuscStringUtils;
import com.cusc.nirvana.user.util.crypt.CryptKeyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LocalVerifyService {
    private static final Logger log = LoggerFactory.getLogger(LocalVerifyService.class);
    @Autowired
    NotifyCloudService notifyCloudService;
    @Autowired
    RnrOrderServiceImpl rnrOrderService;
    @Autowired
    RnrOrderDao rnrOrderDao;
    @Autowired
    MgRnrInfoServiceImpl mgRnrInfoService;
    @Autowired
    MgRnrCardInfoServiceImpl mgRnrCardInfoService;
    @Autowired
    MgRnrCompanyInfoServiceImpl mgRnrCompanyInfoService;
    @Autowired
    MgRnrFileServiceImpl mgRnrFileService;
    @Autowired
    MgRnrLiaisonInfoServiceImpl mgRnrLiaisonInfoService;
    @Autowired
    ManufacturerRnrCallBackHandler manufacturerRnrCallBackHandler;
    @Autowired
    UnbindWorkOrderCallBackHandler unbindWorkOrderCallBackHandler;
    @Autowired
    RnrWorkOrderCallBackHandler rnrWorkOrderCallBackHandler;
    @Autowired
    EnterpriseChangeCallBackHandler enterpriseChangeCallBackHandler;
    @Resource
    private IFileService fileService;
    @Autowired
    private UserClient userClient;
    @Autowired
    private IMgRnrAuthenticationResultService iMgRnrAuthenticationResultService;
    private static final String key = "89c0Cusc268f5A51";

    public Response<PageResult<LocalVerifyListDTO>> orderList(LocalVerifyListRqDTO rq) {
        PageResult pageResult = new PageResult();
        if (StringUtils.isNotBlank((CharSequence)rq.getVin())) {
            rq.setVin(CryptKeyUtil.encryptToBase64((String)rq.getVin()));
        }
        if (StringUtils.isNotBlank((CharSequence)rq.getIccid())) {
            rq.setIccid(CryptKeyUtil.encryptToBase64((String)rq.getIccid()));
        }
        if (StringUtils.isNotBlank((CharSequence)rq.getVinOwnerName())) {
            rq.setVinOwnerName("%" + CryptKeyUtil.encryptToBase64((String)rq.getVinOwnerName()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)rq.getVinOwnerPhone())) {
            rq.setVinOwnerPhone("%" + CryptKeyUtil.encryptToBase64((String)rq.getVinOwnerPhone()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)rq.getVinCompanyName())) {
            rq.setVinCompanyName("%" + CryptKeyUtil.encryptToBase64((String)rq.getVinCompanyName()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)rq.getOrgName())) {
            rq.setOrgName("%" + CryptKeyUtil.encryptToBase64((String)rq.getOrgName()) + "%");
        }
        Integer total = this.rnrOrderService.orderTotal(rq);
        List datas = this.rnrOrderService.orderList(rq);
        for (LocalVerifyListDTO data : datas) {
            data.setVin(CryptKeyUtil.decryptByBase64((String)data.getVin()));
            if (data.getIccid().contains(",")) {
                LinkedList<String> iccids = new LinkedList<String>();
                for (String iccid : data.getIccid().split(",")) {
                    iccids.add(CryptKeyUtil.decryptByBase64((String)iccid));
                }
                data.setIccid(StringUtils.join(iccids, (String)","));
            } else {
                data.setIccid(CryptKeyUtil.decryptByBase64((String)data.getIccid()));
            }
            data.setOrderTypeName(RnrOrderType.getTypeByCode((int)Integer.valueOf(data.getOrderType())).getComment());
            data.setVinOwnerName(CryptKeyUtil.decryptByBase64((String)data.getVinOwnerName()));
            data.setVinOwnerPhone(CryptKeyUtil.decryptByBase64((String)data.getVinOwnerPhone()));
            data.setVinCompanyName(CryptKeyUtil.decryptByBase64((String)data.getVinCompanyName()));
        }
        pageResult.setCurrPage((long)rq.getCurrPage().intValue());
        pageResult.setPageSize((long)rq.getPageSize().intValue());
        pageResult.setTotalCount((long)total.intValue());
        pageResult.setList(datas);
        return Response.createSuccess((Object)pageResult);
    }

    public Response<LocalVerifyPersonDetailDTO> personDetail(LocalVerifyListRqDTO rq) {
        List mgRnrFilePOS;
        RnrOrderPO rnrOrderPO = (RnrOrderPO)this.rnrOrderService.getOne((Wrapper)new QueryWrapper().eq((Object)"uuid", (Object)rq.getRnrOrderInfoId()));
        if (null == rnrOrderPO) {
            return Response.createError((String)"\u5de5\u5355\u4e0d\u5b58\u5728");
        }
        MgRnrInfoPO mgRnrInfoPO = (MgRnrInfoPO)this.mgRnrInfoService.getOne((Wrapper)new QueryWrapper().eq((Object)"uuid", (Object)rnrOrderPO.getRnrId()));
        if (null == mgRnrInfoPO) {
            return Response.createError((String)"\u5de5\u5355\u8be6\u60c5\u4e0d\u5b58\u5728");
        }
        List mgRnrCardInfoPOS = this.mgRnrCardInfoService.list((Wrapper)new QueryWrapper().eq((Object)"rnr_id", (Object)rnrOrderPO.getRnrId()));
        if (null == mgRnrInfoPO || mgRnrCardInfoPOS.size() == 0) {
            return Response.createError((String)"\u5b9e\u540d\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        String companyName = "";
        List mgRnrCompanyInfoPOS = this.mgRnrCompanyInfoService.list((Wrapper)new QueryWrapper().eq((Object)"rnr_id", (Object)rnrOrderPO.getRnrId()));
        if (null != mgRnrCompanyInfoPOS && mgRnrCompanyInfoPOS.size() != 0) {
            companyName = ((MgRnrCompanyInfoPO)mgRnrCompanyInfoPOS.get(0)).getCompanyName();
        }
        if (CollectionUtils.isNotEmpty((Collection)(mgRnrFilePOS = this.mgRnrFileService.getPoByRnridOrderByOrderno(mgRnrInfoPO.getUuid(), mgRnrInfoPO.getTenantNo())))) {
            mgRnrFilePOS.forEach(mgRnrFileDTO -> {
                try {
                    if (RnrFileType.LIVENESS_VIDEO.getCode().intValue() == mgRnrFileDTO.getFileType().intValue() && StringUtils.isNotBlank((CharSequence)mgRnrFileDTO.getFileSystemId())) {
                        String fileUrl = this.fileService.getFileUrl(mgRnrFileDTO.getFileSystemId());
                        mgRnrFileDTO.setFileSystemId(fileUrl);
                    }
                }
                catch (Exception e) {
                    log.error("---\u6839\u636eFileSystemId\u83b7\u53d6\u6587\u4ef6url\u5931\u8d25mgRnrFileDTO\uff1a{}", mgRnrFileDTO);
                    log.error("---\u6839\u636eFileSystemId\u83b7\u53d6\u6587\u4ef6url\u5931\u8d25Exception\uff1a{}", (Throwable)e);
                }
            });
        }
        String orgname = this.rnrOrderDao.getOrgnameById(mgRnrInfoPO.getOrgId());
        LocalVerifyPersonDetailDTO localVerifyPersonDetailDTO = new LocalVerifyPersonDetailDTO();
        localVerifyPersonDetailDTO.setRnrOrderDetail(new LocalVerifyPersonDetailDTO.RnrOrderDetail(orgname, companyName, RnrOrderType.getTypeByCode((int)rnrOrderPO.getOrderType()).getComment(), DateUtil.toString((Date)rnrOrderPO.getCreateTime(), (String)DateUtil.yyyy_MM_dd_HH_mm_ss)));
        ArrayList<LocalVerifyPersonDetailDTO.VinCardMsg> vinCardMsgs = new ArrayList<LocalVerifyPersonDetailDTO.VinCardMsg>();
        for (MgRnrCardInfoPO mgRnrCardInfoPO : mgRnrCardInfoPOS) {
            vinCardMsgs.add(new LocalVerifyPersonDetailDTO.VinCardMsg(mgRnrCardInfoPO.getIotId(), mgRnrCardInfoPO.getIccid(), RnrStatus.getEnumByCode((int)mgRnrCardInfoPO.getRnrStatus()).getComment()));
        }
        localVerifyPersonDetailDTO.setVinCardMsg(vinCardMsgs);
        localVerifyPersonDetailDTO.setVinOwnerMsg(new LocalVerifyPersonDetailDTO.PersonMsg(mgRnrInfoPO.getFullName(), GenderEnum.findByCode((Integer)mgRnrInfoPO.getGender()).getName(), CertTypeEnum.getEnumByCode((String)mgRnrInfoPO.getCertType()).getName(), "", "", mgRnrInfoPO.getCertNumber(), mgRnrInfoPO.getExpiredDate(), mgRnrInfoPO.getCertAddress(), mgRnrInfoPO.getPhone(), mgRnrInfoPO.getContactAddress()));
        for (Object mgRnrFilePO : mgRnrFilePOS) {
            if (StringUtils.isNotBlank((CharSequence)mgRnrFilePO.getLiaisonId()) && "0".equals(mgRnrFilePO.getLiaisonId()) && -1 != RnrFileType.getIdImageFace().indexOf(mgRnrFilePO.getFileType())) {
                localVerifyPersonDetailDTO.getVinOwnerMsg().setIdImageFace(mgRnrFilePO.getFileSystemId());
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)mgRnrFilePO.getLiaisonId()) || !"0".equals(mgRnrFilePO.getLiaisonId()) || -1 == RnrFileType.getIdImageEmblem().indexOf(mgRnrFilePO.getFileType())) continue;
            localVerifyPersonDetailDTO.getVinOwnerMsg().setIdImageEmblem(mgRnrFilePO.getFileSystemId());
        }
        if (1 == mgRnrInfoPO.getIsTrust()) {
            MgRnrLiaisonInfoPO mgRnrLiaisonInfoPO = this.mgRnrLiaisonInfoService.getPoByRnrid(mgRnrInfoPO.getUuid());
            localVerifyPersonDetailDTO.setVinLiaisonMsg(new LocalVerifyPersonDetailDTO.PersonMsg(mgRnrLiaisonInfoPO.getLiaisonName(), GenderEnum.findByCode((Integer)mgRnrLiaisonInfoPO.getLiaisonGender()).getName(), CertTypeEnum.getEnumByCode((String)mgRnrLiaisonInfoPO.getLiaisonCertType()).getName(), "", "", mgRnrLiaisonInfoPO.getLiaisonCertNumber(), mgRnrLiaisonInfoPO.getLiaisonExpiredDate(), mgRnrLiaisonInfoPO.getLiaisonCertAddress(), mgRnrLiaisonInfoPO.getLiaisonPhone(), mgRnrLiaisonInfoPO.getLiaisonContactAddress()));
            for (MgRnrFilePO mgRnrFilePO : mgRnrFilePOS) {
                if ("0".equals(mgRnrFilePO.getLiaisonId())) continue;
                if (RnrFileType.IDENTITY_CARD_BACK.getCode().intValue() == mgRnrFilePO.getFileType().intValue()) {
                    localVerifyPersonDetailDTO.getVinLiaisonMsg().setIdImageFace(mgRnrFilePO.getFileSystemId());
                    continue;
                }
                if (RnrFileType.IDENTITY_CARD_FRONT.getCode().intValue() != mgRnrFilePO.getFileType().intValue()) continue;
                localVerifyPersonDetailDTO.getVinLiaisonMsg().setIdImageEmblem(mgRnrFilePO.getFileSystemId());
            }
        }
        localVerifyPersonDetailDTO.setVerifyFileMsg(new LocalVerifyPersonDetailDTO.VerifyFileMsg());
        for (Object mgRnrFilePO : mgRnrFilePOS) {
            if (RnrFileType.LETTER_ATTORNEY.getCode().intValue() == mgRnrFilePO.getFileType().intValue()) {
                localVerifyPersonDetailDTO.getVerifyFileMsg().getAttorneyImage().add(mgRnrFilePO.getFileSystemId());
                continue;
            }
            if (RnrFileType.CAR_PURCHASE_INVOICE.getCode().intValue() == mgRnrFilePO.getFileType().intValue()) {
                localVerifyPersonDetailDTO.getVerifyFileMsg().getBuyBillImage().add(mgRnrFilePO.getFileSystemId());
                continue;
            }
            if (RnrFileType.CAR_PURCHASE_CONTRACT.getCode().intValue() == mgRnrFilePO.getFileType().intValue()) {
                localVerifyPersonDetailDTO.getVerifyFileMsg().getBuyContractImage().add(mgRnrFilePO.getFileSystemId());
                continue;
            }
            if (RnrFileType.CAR_TRANSFER_CERTIFICATE.getCode().intValue() == mgRnrFilePO.getFileType().intValue()) {
                localVerifyPersonDetailDTO.getVerifyFileMsg().getTransferOwnershipProveImage().add(mgRnrFilePO.getFileSystemId());
                continue;
            }
            if (RnrFileType.VEHUCLE_BIND.getCode().intValue() == mgRnrFilePO.getFileType().intValue() || RnrFileType.DUTY_FILE.getCode().intValue() == mgRnrFilePO.getFileType().intValue()) {
                localVerifyPersonDetailDTO.getVerifyFileMsg().getNetworkAccessContractImage().add(mgRnrFilePO.getFileSystemId());
                continue;
            }
            if (RnrFileType.LIVENESS_SCREEN_FIRST.getCode().intValue() == mgRnrFilePO.getFileType().intValue() || RnrFileType.LIVENESS_SCREEN_TWO.getCode().intValue() == mgRnrFilePO.getFileType().intValue()) {
                localVerifyPersonDetailDTO.getVerifyLivingMsg().getFaceImage().add(mgRnrFilePO.getFileSystemId());
                continue;
            }
            if (RnrFileType.LIVENESS_VIDEO.getCode().intValue() == mgRnrFilePO.getFileType().intValue()) {
                localVerifyPersonDetailDTO.getVerifyLivingMsg().setLivingVideo(mgRnrFilePO.getFileSystemId());
                continue;
            }
            if ("0".equals(mgRnrFilePO.getLiaisonId()) && RnrFileType.IDENTITY_CARD_BACK.getCode().intValue() == mgRnrFilePO.getFileType().intValue()) {
                localVerifyPersonDetailDTO.getVinOwnerMsg().setIdImageFace(mgRnrFilePO.getFileSystemId());
                continue;
            }
            if (!"0".equals(mgRnrFilePO.getLiaisonId()) || RnrFileType.IDENTITY_CARD_FRONT.getCode().intValue() != mgRnrFilePO.getFileType().intValue()) continue;
            localVerifyPersonDetailDTO.getVinOwnerMsg().setIdImageEmblem(mgRnrFilePO.getFileSystemId());
        }
        LinkedHashMap<String, String> verifySuggestion = new LinkedHashMap<String, String>();
        verifySuggestion.put(PassCodeEnum.INFO_INCOMPLETE.getCode().toString(), PassCodeEnum.INFO_INCOMPLETE.getComment());
        verifySuggestion.put(PassCodeEnum.INFO_ATYPISM.getCode().toString(), PassCodeEnum.INFO_ATYPISM.getComment());
        verifySuggestion.put(PassCodeEnum.INFO_NOT_FOUND.getCode().toString(), PassCodeEnum.INFO_NOT_FOUND.getComment());
        verifySuggestion.put(PassCodeEnum.PIC_FORMAT_ERROR.getCode().toString(), PassCodeEnum.PIC_FORMAT_ERROR.getComment());
        verifySuggestion.put(PassCodeEnum.PIC_BLURRING.getCode().toString(), PassCodeEnum.PIC_BLURRING.getComment());
        MgRnrAuthenticationResultDTO bean = new MgRnrAuthenticationResultDTO();
        bean.setRnrId(rnrOrderPO.getRnrId());
        List authenticationResultDTOS = this.iMgRnrAuthenticationResultService.queryByList(bean);
        if (CollectionUtils.isNotEmpty((Collection)authenticationResultDTOS)) {
            ArrayList authResultInfo = new ArrayList(authenticationResultDTOS.size());
            authenticationResultDTOS.forEach(authResultDTO -> {
                EnterpriseVerifyDetailDTO.AuthResult authResult = new EnterpriseVerifyDetailDTO.AuthResult();
                authResult.setTpAction(authResultDTO.getAuthWayType());
                authResult.setTpActionName(AuthWayTypeEnum.getEnumByCode((String)authResultDTO.getAuthWayType()).getName());
                authResult.setMessage(authResultDTO.getAuthResultMsg());
                authResult.setSuccess(Boolean.valueOf("1".equals(authResultDTO.getAuthResult())));
                authResultInfo.add(authResult);
            });
            localVerifyPersonDetailDTO.setAuthResultInfo(authResultInfo);
        }
        UserDTO userDTO = new UserDTO();
        userDTO.setUuid(rq.getUserId());
        userDTO.setApplicationId(rq.getApplicationId());
        userDTO.setTenantNo(rq.getTenantNo());
        Response userDTOResponse = this.userClient.getByUuid(userDTO);
        UserDTO user = (UserDTO)userDTOResponse.getData();
        log.info("\u5ba1\u6838\u4eba\u7684\u4fe1\u606f\u8fd4\u53c2:{}", (Object)JSON.toJSONString((Object)user));
        if (userDTOResponse == null || user == null) {
            return Response.createError((String)"\u5ba1\u6838\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        localVerifyPersonDetailDTO.setVerifyMsg(new LocalVerifyPersonDetailDTO.VerifyMsg(user.getUserName(), DateUtil.toString((Date)new Date(), (String)DateUtil.yyyy_MM_dd), verifySuggestion, rnrOrderPO.getOrderStatus()));
        return Response.createSuccess((Object)localVerifyPersonDetailDTO);
    }

    @Transactional(rollbackFor={Throwable.class})
    public Response submit(LocalVerifySubmitRq rq) {
        RnrOrderPO rnrOrderPO = this.rnrOrderService.getPoByUuid(rq.getRnrOrderInfoId());
        RnrOrderType typeByCode = RnrOrderType.getTypeByCode((int)rnrOrderPO.getOrderType());
        WorkOrderTypeEnum workOrderTypeEnum = WorkOrderTypeEnum.getWorkOrderTypeEnumByRnrOrderType((RnrOrderType)typeByCode);
        WorkOrderReviewCallBackRequestDTO dto = new WorkOrderReviewCallBackRequestDTO();
        dto.setBusinessObjectId(rnrOrderPO.getUuid());
        if (RnrOrderStatusEnum.PASS.getCode().toString().equals(rq.getAuditResult())) {
            dto.setAuditResult("1");
        } else if (RnrOrderStatusEnum.NOT_PASS.getCode().toString().equals(rq.getAuditResult())) {
            dto.setAuditResult("2");
        }
        if ("rnrWorkOrderCallBackHandler".equals(workOrderTypeEnum.getWorkOrderCallBackServiceName())) {
            this.rnrWorkOrderCallBackHandler.reviewCallBack(dto);
        } else if ("manufacturerRnrCallBackHandler".equals(workOrderTypeEnum.getWorkOrderCallBackServiceName())) {
            this.manufacturerRnrCallBackHandler.reviewCallBack(dto);
        } else if ("unbindWorkOrderCallBackHandler".equals(workOrderTypeEnum.getWorkOrderCallBackServiceName())) {
            this.unbindWorkOrderCallBackHandler.reviewCallBack(dto);
        } else if ("enterpriseChangeCallBackHandler".equals(workOrderTypeEnum.getWorkOrderCallBackServiceName())) {
            this.enterpriseChangeCallBackHandler.reviewCallBack(dto);
        }
        rnrOrderPO.setAuditTime(new Date());
        rnrOrderPO.setOperator(rq.getUserId());
        rnrOrderPO.setOrderStatus(Integer.valueOf(Integer.parseInt(rq.getAuditResult())));
        rnrOrderPO.setVerifyComments(StringUtils.join((Iterable)rq.getAuditNote(), (String)","));
        rnrOrderPO.setComment(rq.getOtherComments());
        this.rnrOrderDao.updateById((Object)rnrOrderPO);
        List mgRnrCardInfoDTOS = this.mgRnrCardInfoService.getByRnrid(rnrOrderPO.getRnrId());
        MgRnrInfoPO mgRnrInfoPO = this.mgRnrInfoService.getPoByUuid(rnrOrderPO.getRnrId());
        this.notifyCloudService.notifyResult(mgRnrCardInfoDTOS, rnrOrderPO.getRnrBizzType().toString(), rnrOrderPO.getId().toString(), mgRnrInfoPO.getOrgId(), rnrOrderPO.getOrderStatus().toString());
        return Response.createSuccess((String)"\u8bf7\u6c42\u6210\u529f");
    }

    public Response retry(LocalVerifySubmitRq rq) {
        List mgRnrFilePOS;
        List mgRnrCompanyInfoPOS;
        RnrRelationDTO rsBean = new RnrRelationDTO();
        rsBean.setRequestId(CuscStringUtils.generateUuid());
        RnrOrderPO rnrOrderPO = (RnrOrderPO)this.rnrOrderService.getOne((Wrapper)new QueryWrapper().eq((Object)"uuid", (Object)rq.getRnrOrderInfoId()));
        if (null == rnrOrderPO) {
            return Response.createError((String)"\u5de5\u5355\u4e0d\u5b58\u5728");
        }
        RnrOrderDTO rnrOrderDTO = RnrOrderConverter.INSTANCE.poToDto(rnrOrderPO);
        rsBean.setOrder(rnrOrderDTO);
        rsBean.setTenantNo(rnrOrderDTO.getTenantNo());
        if (rnrOrderDTO.getOrderType().equals("2")) {
            rsBean.setIsSecondHandCar(Integer.valueOf(1));
        } else {
            rsBean.setIsSecondHandCar(Integer.valueOf(0));
        }
        boolean isTrust = false;
        MgRnrInfoPO mgRnrInfoPO = this.mgRnrInfoService.getPoByUuid(rnrOrderPO.getRnrId());
        if (null == mgRnrInfoPO) {
            return Response.createError((String)"\u5de5\u5355\u5b9e\u540d\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        MgRnrInfoDTO info = MgRnrInfoConverter.INSTANCE.poToDto(mgRnrInfoPO);
        rsBean.setInfo(info);
        rsBean.setIsTrust(info.getIsTrust());
        if (info.getIsTrust().equals("1")) {
            isTrust = true;
        }
        if (null != (mgRnrCompanyInfoPOS = this.mgRnrCompanyInfoService.list((Wrapper)new QueryWrapper().eq((Object)"rnr_id", (Object)rnrOrderPO.getRnrId()))) && mgRnrCompanyInfoPOS.size() != 0) {
            MgRnrCompanyInfoDTO mgRnrCompanyInfoDTO = MgRnrCompanyInfoConverter.INSTANCE.poToDto((MgRnrCompanyInfoPO)mgRnrCompanyInfoPOS.get(0));
        }
        if (isTrust) {
            ArrayList<MgRnrLiaisonInfoDTO> rnrLiaisonList = new ArrayList<MgRnrLiaisonInfoDTO>();
            MgRnrLiaisonInfoPO mgRnrLiaisonInfoPO = this.mgRnrLiaisonInfoService.getPoByRnrid(mgRnrInfoPO.getUuid());
            rnrLiaisonList.add(MgRnrLiaisonInfoConverter.INSTANCE.poToDto(mgRnrLiaisonInfoPO));
            rsBean.setRnrLiaisonList(rnrLiaisonList);
        }
        if ((mgRnrFilePOS = this.mgRnrFileService.getPoByRnridOrderByOrderno(mgRnrInfoPO.getUuid(), mgRnrInfoPO.getTenantNo())).size() > 0) {
            List rnrFileList = MgRnrImageConverter.INSTANCE.poListToDtoList(mgRnrFilePOS);
            rsBean.setRnrFileList(rnrFileList);
        }
        return Response.createSuccess((Object)rsBean);
    }

    public Response validationRnrOrder(LocalVerifyListRqDTO rq) {
        String iccidEncryptStr;
        SymmetricCrypto sm4 = SmUtil.sm4((byte[])key.getBytes());
        String vinEncryptStr = sm4.encryptBase64(rq.getVin());
        Integer returnInt = this.rnrOrderDao.validationRnrOrder(vinEncryptStr, iccidEncryptStr = sm4.encryptBase64(rq.getIccid()));
        if (returnInt > 0) {
            return Response.createSuccess();
        }
        return Response.createError();
    }
}

