/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.RnrFileType;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOrderType;
import com.cusc.nirvana.user.rnr.mg.constants.RnrStatus;
import com.cusc.nirvana.user.rnr.mg.dto.CompanyCorporationChangeRespDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCompanyInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrFileDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import com.cusc.nirvana.user.rnr.mg.service.impl.MgRnrCompanyInfoServiceImpl;
import com.cusc.nirvana.user.rnr.mg.service.impl.MgRnrFileServiceImpl;
import com.cusc.nirvana.user.rnr.mg.service.impl.MgRnrInfoServiceImpl;
import com.cusc.nirvana.user.rnr.mg.service.impl.RnrOrderServiceImpl;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocalChangeEnterpriseRnrPersonService {
    private static final Logger log = LoggerFactory.getLogger(LocalChangeEnterpriseRnrPersonService.class);
    @Autowired
    private RnrOrderServiceImpl rnrOrderService;
    @Autowired
    private MgRnrCompanyInfoServiceImpl mgRnrCompanyInfoService;
    @Autowired
    private MgRnrInfoServiceImpl mgRnrInfoService;
    @Autowired
    private MgRnrFileServiceImpl mgRnrFileService;

    public Response<CompanyCorporationChangeRespDTO> enterpriseRnrPersonDetail(String uuid) {
        CompanyCorporationChangeRespDTO rs = new CompanyCorporationChangeRespDTO();
        RnrOrderDTO queryBean = new RnrOrderDTO();
        queryBean.setUuid(uuid);
        RnrOrderDTO rnrOrderDTO = this.rnrOrderService.getByUuid(queryBean);
        if (null == rnrOrderDTO) {
            rs.setErrorCode(Integer.valueOf(10001));
            rs.setErrorMsg("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5de5\u5355\u4fe1\u606f");
            return Response.createError((String)rs.getErrorMsg(), (Integer)rs.getErrorCode(), (Object)rs);
        }
        CompanyCorporationChangeRespDTO.OrderDto orderDto = new CompanyCorporationChangeRespDTO.OrderDto();
        RnrOrderType rnrOrderType = RnrOrderType.getTypeByCode((int)rnrOrderDTO.getOrderType());
        orderDto.setOrderType(rnrOrderType.getComment());
        String organName = this.rnrOrderService.getOrganNameForOrgId(rnrOrderDTO.getOrgId());
        orderDto.setOrganName(organName);
        MgRnrCompanyInfoDTO bean2 = new MgRnrCompanyInfoDTO();
        bean2.setRnrId(rnrOrderDTO.getRnrId());
        MgRnrCompanyInfoDTO mgRnrCompanyInfoDTO = this.mgRnrCompanyInfoService.getByRnrid(bean2);
        orderDto.setCompanyName(mgRnrCompanyInfoDTO.getCompanyName());
        MgRnrInfoDTO bean3 = new MgRnrInfoDTO();
        bean3.setUuid(rnrOrderDTO.getUuid());
        MgRnrInfoDTO mgRnrInfoDTO = this.mgRnrInfoService.getByUuid(bean3);
        orderDto.setUpdateTime(mgRnrInfoDTO.getUpdateTime());
        orderDto.setOrderStatus(rnrOrderDTO.getOrderStatus());
        rs.setOrderDto(orderDto);
        MgRnrInfoDTO queryBean2 = new MgRnrInfoDTO();
        queryBean2.setTenantNo(rnrOrderDTO.getTenantNo());
        queryBean2.setRnrStatus(Integer.valueOf(RnrStatus.RNR.getCode()));
        queryBean2.setCompanyName(rs.getOrderDto().getCompanyName());
        List mgRnrInfoDTOList = this.mgRnrInfoService.queryByList(queryBean2);
        if (mgRnrInfoDTOList.size() <= 0) {
            rs.setErrorCode(Integer.valueOf(10002));
            rs.setErrorMsg("\u672a\u67e5\u8be2\u5230\u539f\u4f01\u4e1a\u548c\u8d23\u4efb\u4eba\u4fe1\u606f");
            return Response.createError((String)rs.getErrorMsg(), (Integer)rs.getErrorCode(), (Object)rs);
        }
        CompanyCorporationChangeRespDTO.OldMgRnrInfoDto oldMgRnrInfoDto = new CompanyCorporationChangeRespDTO.OldMgRnrInfoDto();
        MgRnrInfoDTO mgRnrInfoDTO2 = (MgRnrInfoDTO)mgRnrInfoDTOList.get(0);
        oldMgRnrInfoDto.setFullName(mgRnrInfoDTO2.getFullName());
        oldMgRnrInfoDto.setCompanyName(mgRnrInfoDTO2.getCompanyName());
        rs.setOldMgRnrInfoDto(oldMgRnrInfoDto);
        MgRnrFileDTO bean = new MgRnrFileDTO();
        bean.setRnrId(rnrOrderDTO.getUuid());
        bean.setTenantNo(rnrOrderDTO.getTenantNo());
        List mgRnrFileDTOList = this.mgRnrFileService.getByRnrid(bean);
        bean.setTenantNo(rnrOrderDTO.getTenantNo());
        if (mgRnrFileDTOList.size() < 0) {
            rs.setErrorCode(Integer.valueOf(10003));
            rs.setErrorMsg("\u65b0\u8d23\u4efb\u4eba\u4fe1\u606f\u67e5\u4e0d\u5230\u8bc1\u4ef6\u4fe1\u606f");
            return Response.createError((String)rs.getErrorMsg(), (Integer)rs.getErrorCode(), (Object)rs);
        }
        mgRnrFileDTOList.forEach(mgRnrFileDTO -> {
            try {
                if (!StringUtils.isNotBlank((CharSequence)mgRnrFileDTO.getFileSystemId())) return;
            }
            catch (Exception e) {
                log.error("---\u6839\u636eFileSystemId\u83b7\u53d6\u6587\u4ef6url\u5931\u8d25mgRnrFileDTO\uff1a{}", mgRnrFileDTO);
                log.error("---\u6839\u636eFileSystemId\u83b7\u53d6\u6587\u4ef6url\u5931\u8d25Exception\uff1a{}", (Throwable)e);
            }
        });
        MgRnrInfoDTO queryBean3 = new MgRnrInfoDTO();
        queryBean3.setUuid(rnrOrderDTO.getUuid());
        MgRnrInfoDTO mgRnrInfoDTO3 = this.mgRnrInfoService.getByUuid(queryBean3);
        if (null == mgRnrInfoDTO3) {
            rs.setErrorCode(Integer.valueOf(10004));
            rs.setErrorMsg("\u672a\u67e5\u8be2\u5230\u65b0\u8d23\u4efb\u4eba\u4fe1\u606f");
            return Response.createError((String)rs.getErrorMsg(), (Integer)rs.getErrorCode(), (Object)rs);
        }
        CompanyCorporationChangeRespDTO.NewMgRnrInfoDto newMgRnrInfoDto = new CompanyCorporationChangeRespDTO.NewMgRnrInfoDto();
        newMgRnrInfoDto.setFullName(mgRnrInfoDTO3.getFullName());
        newMgRnrInfoDto.setGender(mgRnrInfoDTO3.getGender());
        newMgRnrInfoDto.setCertType(mgRnrInfoDTO3.getCertType());
        newMgRnrInfoDto.setCertNumber(mgRnrInfoDTO3.getCertNumber());
        newMgRnrInfoDto.setExpiredDate(mgRnrInfoDTO3.getExpiredDate());
        newMgRnrInfoDto.setCertAddress(mgRnrInfoDTO3.getCertAddress());
        newMgRnrInfoDto.setPhone(mgRnrInfoDTO3.getPhone());
        newMgRnrInfoDto.setContactAddress(mgRnrInfoDTO3.getContactAddress());
        for (MgRnrFileDTO mf : mgRnrFileDTOList) {
            if (mf.getFileType().equals(RnrFileType.IDENTITY_CARD_BACK.getCode())) {
                newMgRnrInfoDto.setIdentityCardBackForUuId(mf.getFileBase64());
                continue;
            }
            if (!mf.getFileType().equals(RnrFileType.IDENTITY_CARD_FRONT.getCode())) continue;
            newMgRnrInfoDto.setIdentityCardFrontForUuId(mf.getFileBase64());
        }
        if (StringUtils.isEmpty((CharSequence)newMgRnrInfoDto.getIdentityCardBackForUuId()) || StringUtils.isEmpty((CharSequence)newMgRnrInfoDto.getIdentityCardFrontForUuId())) {
            rs.setErrorCode(Integer.valueOf(10005));
            rs.setErrorMsg("\u65b0\u8d23\u4efb\u4eba\u4fe1\u606f\u8bc1\u4ef6\u4fe1\u606f\u4e0d\u9f50");
            return Response.createError((String)rs.getErrorMsg(), (Integer)rs.getErrorCode(), (Object)rs);
        }
        rs.setNewMgRnrInfoDto(newMgRnrInfoDto);
        for (MgRnrFileDTO mf : mgRnrFileDTOList) {
            if (mf.getFileType().equals(RnrFileType.ENTERPRISE_AUTH_FILE.getCode())) {
                rs.setEnterpriseAuthFileForUuId(mf.getFileBase64());
                continue;
            }
            if (mf.getFileType().equals(RnrFileType.LIVENESS_SCREEN_FIRST.getCode())) {
                rs.setLivenessScreenFirstForUuId(mf.getFileBase64());
                continue;
            }
            if (!mf.getFileType().equals(RnrFileType.LIVENESS_VIDEO.getCode())) continue;
            rs.setLivenessVideoForUuId(mf.getFileBase64());
        }
        if (StringUtils.isEmpty((CharSequence)rs.getEnterpriseAuthFileForUuId())) {
            rs.setErrorCode(Integer.valueOf(10005));
            rs.setErrorMsg("\u6388\u6743\u4e66\u4fe1\u606f\u6709\u8bef");
            return Response.createError((String)rs.getErrorMsg(), (Integer)rs.getErrorCode(), (Object)rs);
        }
        if (StringUtils.isEmpty((CharSequence)rs.getLivenessScreenFirstForUuId()) || StringUtils.isEmpty((CharSequence)rs.getLivenessVideoForUuId())) {
            rs.setErrorCode(Integer.valueOf(10005));
            rs.setErrorMsg("\u8bc1\u4ef6\u4fe1\u606f\u4e0d\u9f50");
            return Response.createError((String)rs.getErrorMsg(), (Integer)rs.getErrorCode(), (Object)rs);
        }
        return Response.createSuccess((Object)rs);
    }
}

