/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.alibaba.fastjson.JSON;
import com.cusc.nirvana.common.loader.CollectionUtils;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.client.UserClient;
import com.cusc.nirvana.user.eiam.dto.UserDTO;
import com.cusc.nirvana.user.rnr.mg.constants.AuthWayTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.CertTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.CompanyTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.GenderEnum;
import com.cusc.nirvana.user.rnr.mg.constants.IndustryTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrFileType;
import com.cusc.nirvana.user.rnr.mg.dto.EnterpriseVerifyDetailDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrAuthenticationResultDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCompanyInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrFileDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import com.cusc.nirvana.user.rnr.mg.service.IEnterpriseVerifyService;
import com.cusc.nirvana.user.rnr.mg.service.IFileService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrAuthenticationResultService;
import com.cusc.nirvana.user.rnr.mg.service.impl.MgRnrCompanyInfoServiceImpl;
import com.cusc.nirvana.user.rnr.mg.service.impl.MgRnrFileServiceImpl;
import com.cusc.nirvana.user.rnr.mg.service.impl.MgRnrInfoServiceImpl;
import com.cusc.nirvana.user.rnr.mg.service.impl.RnrOrderServiceImpl;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnterpriseVerifyServiceImpl
implements IEnterpriseVerifyService {
    private static final Logger log = LoggerFactory.getLogger(EnterpriseVerifyServiceImpl.class);
    @Autowired
    private RnrOrderServiceImpl rnrOrderService;
    @Autowired
    private MgRnrCompanyInfoServiceImpl mgRnrCompanyInfoService;
    @Autowired
    private MgRnrInfoServiceImpl mgRnrInfoService;
    @Autowired
    private MgRnrFileServiceImpl mgRnrFileService;
    @Autowired
    private IMgRnrAuthenticationResultService iMgRnrAuthenticationResultService;
    @Autowired
    private UserClient userClient;
    @Resource
    private IFileService fileService;

    public Response<EnterpriseVerifyDetailDTO> getEnterpriseDetail(RnrOrderDTO rnrOrderDTO) {
        EnterpriseVerifyDetailDTO enterpriseVerifyDetailDTO = new EnterpriseVerifyDetailDTO();
        RnrOrderDTO rnrOrderDetails = this.rnrOrderService.getByUuid(rnrOrderDTO);
        log.info("\u67e5\u8be2\u5de5\u5355\u4fe1\u606f\u8fd4\u53c2:{}", (Object)JSON.toJSONString((Object)rnrOrderDetails));
        if (null == rnrOrderDetails) {
            return Response.createError((String)"\u5de5\u5355\u4e0d\u5b58\u5728");
        }
        BeanUtils.copyProperties((Object)rnrOrderDetails, (Object)enterpriseVerifyDetailDTO.getRnrOrderDetail());
        MgRnrCompanyInfoDTO companyInfoParams = new MgRnrCompanyInfoDTO();
        companyInfoParams.setRnrId(rnrOrderDetails.getRnrId());
        MgRnrCompanyInfoDTO mgRnrCompanyInfoDTO = this.mgRnrCompanyInfoService.getByRnrid(companyInfoParams);
        log.info("\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f\u8fd4\u53c2:{}", (Object)JSON.toJSONString((Object)mgRnrCompanyInfoDTO));
        if (mgRnrCompanyInfoDTO == null) {
            return Response.createError((String)"\u4f01\u4e1a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BeanUtils.copyProperties((Object)mgRnrCompanyInfoDTO, (Object)enterpriseVerifyDetailDTO.getCompanyInfoDetail());
        MgRnrInfoDTO rnrInfoParams = new MgRnrInfoDTO();
        rnrInfoParams.setUuid(rnrOrderDetails.getRnrId());
        MgRnrInfoDTO mgRnrInfoDTO = this.mgRnrInfoService.getByUuid(rnrInfoParams);
        log.info("\u67e5\u8be2\u8d23\u4efb\u4eba\u7684\u4fe1\u606f\u8fd4\u53c2:{}", (Object)JSON.toJSONString((Object)mgRnrInfoDTO));
        if (mgRnrInfoDTO == null || StringUtils.isBlank((CharSequence)mgRnrInfoDTO.getCertType())) {
            return Response.createError((String)"\u5b9e\u540d\u8d23\u4efb\u4eba\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        EnterpriseVerifyDetailDTO.CorporationInfoDetail corporationInfoDetail = enterpriseVerifyDetailDTO.getCorporationInfoDetail();
        corporationInfoDetail.setCorporationName(mgRnrInfoDTO.getFullName());
        corporationInfoDetail.setCorporationGender(mgRnrInfoDTO.getGender());
        corporationInfoDetail.setCorporationGenderName(GenderEnum.findNameByCode((Integer)mgRnrInfoDTO.getGender()));
        corporationInfoDetail.setCorporationCertType(CertTypeEnum.getEnumByCode((String)mgRnrInfoDTO.getCertType()).getName());
        corporationInfoDetail.setCorporationCertNumber(mgRnrInfoDTO.getCertNumber());
        corporationInfoDetail.setCorporationCertExpirationDate(mgRnrInfoDTO.getExpiredDate());
        corporationInfoDetail.setCorporationCertAddress(mgRnrInfoDTO.getCertAddress());
        corporationInfoDetail.setCorporationPhone(mgRnrInfoDTO.getPhone());
        corporationInfoDetail.setCorporationContactAddress(mgRnrInfoDTO.getContactAddress());
        BeanUtils.copyProperties((Object)mgRnrInfoDTO, (Object)enterpriseVerifyDetailDTO.getCorporationInfoDetail());
        MgRnrFileDTO file = new MgRnrFileDTO();
        file.setRnrId(rnrOrderDetails.getRnrId());
        List fileList = this.mgRnrFileService.queryByList(file);
        log.info("\u67e5\u8be2\u6587\u4ef6\u4fe1\u606f\u8fd4\u53c2:{}", (Object)JSON.toJSONString((Object)fileList));
        if (CollectionUtils.isEmpty((Collection)fileList)) {
            return Response.createError((String)"\u4f01\u4e1a\u76f8\u5173\u8bc1\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        fileList.forEach(mgRnrFileDTO -> {
            try {
                if (RnrFileType.LIVENESS_VIDEO.getCode().intValue() == mgRnrFileDTO.getFileType().intValue() && StringUtils.isNotBlank((CharSequence)mgRnrFileDTO.getFileSystemId())) {
                    String fileUrl = this.fileService.getFileUrl(mgRnrFileDTO.getFileSystemId());
                    mgRnrFileDTO.setFileBase64(fileUrl);
                }
            }
            catch (Exception e) {
                log.error("---\u6839\u636eFileSystemId\u83b7\u53d6\u6587\u4ef6url\u5931\u8d25mgRnrFileDTO\uff1a{}", mgRnrFileDTO);
                log.error("---\u6839\u636eFileSystemId\u83b7\u53d6\u6587\u4ef6url\u5931\u8d25Exception\uff1a{}", (Throwable)e);
            }
        });
        Map<Integer, List<MgRnrFileDTO>> fileMap2List = fileList.stream().collect(Collectors.groupingBy(MgRnrFileDTO::getFileType));
        ArrayList<String> fileSystemList = new ArrayList<String>();
        log.warn("fileList++++++++{}", JSON.toJSON((Object)fileList));
        for (MgRnrFileDTO mgRnrFileDTO2 : fileList) {
            if (!RnrFileType.VEHUCLE_BIND.getCode().equals(mgRnrFileDTO2.getFileType()) && !RnrFileType.DUTY_FILE.getCode().equals(mgRnrFileDTO2.getFileType()) && !RnrFileType.ENTERPRISE_AUTH_FILE.getCode().equals(mgRnrFileDTO2.getFileType())) continue;
            fileSystemList.add(mgRnrFileDTO2.getFileSystemId());
        }
        log.warn("fileSystemList========={}", JSON.toJSON(fileSystemList));
        enterpriseVerifyDetailDTO.getCorporationInfoDetail().setFileSystemList(fileSystemList);
        enterpriseVerifyDetailDTO.getCompanyInfoDetail().setCompanyLicenseFiles(fileMap2List.get(RnrFileType.ENTERPRISE_PIC.getCode()));
        enterpriseVerifyDetailDTO.getCompanyInfoDetail().setCompanyCertType(CertTypeEnum.getEnumByCode((String)mgRnrCompanyInfoDTO.getCompanyCertType()).getName());
        enterpriseVerifyDetailDTO.getCompanyInfoDetail().setCompanyType(null != CompanyTypeEnum.getEnumByCode((String)mgRnrCompanyInfoDTO.getCompanyType()) ? CompanyTypeEnum.getEnumByCode((String)mgRnrCompanyInfoDTO.getCompanyType()).getValue() : "");
        enterpriseVerifyDetailDTO.getCompanyInfoDetail().setIndustryType(null != IndustryTypeEnum.getEnumByCode((String)mgRnrCompanyInfoDTO.getIndustryType()) ? IndustryTypeEnum.getEnumByCode((String)mgRnrCompanyInfoDTO.getIndustryType()).getValue() : "");
        enterpriseVerifyDetailDTO.getCorporationInfoDetail().setAuthorizationLetterPic(fileMap2List.get(RnrFileType.ENTERPRISE_AUTH_FILE.getCode()));
        enterpriseVerifyDetailDTO.getVerifyLivingMsg().getFaceImages().addAll((Collection)fileMap2List.get(RnrFileType.LIVENESS_SCREEN_FIRST.getCode()));
        enterpriseVerifyDetailDTO.getVerifyLivingMsg().getFaceImages().addAll((Collection)fileMap2List.get(RnrFileType.LIVENESS_SCREEN_TWO.getCode()));
        enterpriseVerifyDetailDTO.getVerifyLivingMsg().setLivingVideo(fileMap2List.get(RnrFileType.LIVENESS_VIDEO.getCode()).get(0));
        String certType = mgRnrInfoDTO.getCertType();
        if (CertTypeEnum.IDCARD.getCode().equalsIgnoreCase(certType)) {
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertFrontPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.IDENTITY_CARD_BACK.getCode())) ? fileMap2List.get(RnrFileType.IDENTITY_CARD_BACK.getCode()).get(0) : null);
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertBackPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.IDENTITY_CARD_FRONT.getCode())) ? fileMap2List.get(RnrFileType.IDENTITY_CARD_FRONT.getCode()).get(0) : null);
        } else if (CertTypeEnum.HKIDCARD.getCode().equalsIgnoreCase(certType)) {
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertFrontPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.HK_MACAO_PASSPORT_FRONT.getCode())) ? fileMap2List.get(RnrFileType.HK_MACAO_PASSPORT_FRONT.getCode()).get(0) : null);
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertBackPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.HK_MACAO_PASSPORT_BACK.getCode())) ? fileMap2List.get(RnrFileType.HK_MACAO_PASSPORT_BACK.getCode()).get(0) : null);
        } else if (CertTypeEnum.PASSPORT.getCode().equalsIgnoreCase(certType)) {
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertFrontPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.FOREIGN_NATIONAL_PASSPORT_FRONT.getCode())) ? fileMap2List.get(RnrFileType.FOREIGN_NATIONAL_PASSPORT_FRONT.getCode()).get(0) : null);
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertBackPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.FOREIGN_NATIONAL_PASSPORT_BACK.getCode())) ? fileMap2List.get(RnrFileType.FOREIGN_NATIONAL_PASSPORT_BACK.getCode()).get(0) : null);
        } else if (CertTypeEnum.PLA.getCode().equalsIgnoreCase(certType)) {
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertFrontPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.OFFICIAL_CARD_FRONT.getCode())) ? fileMap2List.get(RnrFileType.OFFICIAL_CARD_FRONT.getCode()).get(0) : null);
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertBackPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.OFFICIAL_CARD_BACK.getCode())) ? fileMap2List.get(RnrFileType.OFFICIAL_CARD_BACK.getCode()).get(0) : null);
        } else if (CertTypeEnum.POLICEPAPER.getCode().equalsIgnoreCase(certType)) {
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertFrontPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.POLICE_CARD_FRONT.getCode())) ? fileMap2List.get(RnrFileType.POLICE_CARD_FRONT.getCode()).get(0) : null);
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertBackPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.POLICE_CARD_BACK.getCode())) ? fileMap2List.get(RnrFileType.POLICE_CARD_BACK.getCode()).get(0) : null);
        } else if (CertTypeEnum.TAIBAOZHENG.getCode().equalsIgnoreCase(certType)) {
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertFrontPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.TAIWAN_CARD_FRONT.getCode())) ? fileMap2List.get(RnrFileType.TAIWAN_CARD_FRONT.getCode()).get(0) : null);
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertBackPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.TAIWAN_CARD_BACK.getCode())) ? fileMap2List.get(RnrFileType.TAIWAN_CARD_BACK.getCode()).get(0) : null);
        } else if (CertTypeEnum.HKRESIDENCECARD.getCode().equalsIgnoreCase(certType)) {
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertFrontPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.HK_MACAO_RESIDENCE_PERMIT_FRONT.getCode())) ? fileMap2List.get(RnrFileType.HK_MACAO_RESIDENCE_PERMIT_FRONT.getCode()).get(0) : null);
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertBackPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.HK_MACAO_RESIDENCE_PERMIT_BACK.getCode())) ? fileMap2List.get(RnrFileType.HK_MACAO_RESIDENCE_PERMIT_BACK.getCode()).get(0) : null);
        } else if (CertTypeEnum.TWRESIDENCECARD.getCode().equalsIgnoreCase(certType)) {
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertFrontPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.TAIWAN_RESIDENCE_PERMIT_FRONT.getCode())) ? fileMap2List.get(RnrFileType.TAIWAN_RESIDENCE_PERMIT_FRONT.getCode()).get(0) : null);
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertBackPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.TAIWAN_RESIDENCE_PERMIT_BACK.getCode())) ? fileMap2List.get(RnrFileType.TAIWAN_RESIDENCE_PERMIT_BACK.getCode()).get(0) : null);
        } else if (CertTypeEnum.SOCIAL_ORG_LEGAL_PERSON_CERT.getCode().equalsIgnoreCase(certType)) {
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertFrontPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.ENTERPRISE_AUTH_FILE.getCode())) ? fileMap2List.get(RnrFileType.ENTERPRISE_AUTH_FILE.getCode()).get(0) : null);
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertBackPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.ENTERPRISE_AUTH_FILE.getCode())) ? fileMap2List.get(RnrFileType.ENTERPRISE_AUTH_FILE.getCode()).get(0) : null);
        } else if (CertTypeEnum.RESIDENCE.getCode().equalsIgnoreCase(certType)) {
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertFrontPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.RESIDENCE_BOOKLET_FRONT.getCode())) ? fileMap2List.get(RnrFileType.RESIDENCE_BOOKLET_FRONT.getCode()).get(0) : null);
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertBackPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.RESIDENCE_BOOKLET_BACK.getCode())) ? fileMap2List.get(RnrFileType.RESIDENCE_BOOKLET_BACK.getCode()).get(0) : null);
        } else if (CertTypeEnum.OTHER.getCode().equalsIgnoreCase(certType)) {
            enterpriseVerifyDetailDTO.getCorporationInfoDetail().setCorporationCertFrontPic(CollectionUtils.isNotEmpty((Collection)fileMap2List.get(RnrFileType.OTHER.getCode())) ? fileMap2List.get(RnrFileType.OTHER.getCode()).get(0) : null);
        }
        MgRnrAuthenticationResultDTO bean = new MgRnrAuthenticationResultDTO();
        bean.setRnrId(rnrOrderDetails.getRnrId());
        List authenticationResultDTOS = this.iMgRnrAuthenticationResultService.queryByList(bean);
        if (CollectionUtils.isNotEmpty((Collection)authenticationResultDTOS)) {
            ArrayList authResultInfo = new ArrayList(authenticationResultDTOS.size());
            authenticationResultDTOS.forEach(authResultDTO -> {
                EnterpriseVerifyDetailDTO.AuthResult authResult = new EnterpriseVerifyDetailDTO.AuthResult();
                authResult.setTpAction(authResultDTO.getAuthWayType());
                authResult.setTpActionName(AuthWayTypeEnum.getEnumByCode((String)authResultDTO.getAuthWayType()).getName());
                authResult.setMessage(authResultDTO.getAuthResultMsg());
                authResult.setSuccess(Boolean.valueOf("1".equals(authResultDTO.getAuthResult())));
                authResultInfo.add(authResult);
            });
            enterpriseVerifyDetailDTO.setAuthResultInfo(authResultInfo);
        }
        UserDTO userDTO = new UserDTO();
        userDTO.setUuid(rnrOrderDTO.getUserId());
        userDTO.setApplicationId(rnrOrderDTO.getApplicationId());
        userDTO.setTenantNo(rnrOrderDTO.getTenantNo());
        Response userDTOResponse = this.userClient.getByUuid(userDTO);
        UserDTO user = (UserDTO)userDTOResponse.getData();
        log.info("\u5ba1\u6838\u4eba\u7684\u4fe1\u606f\u8fd4\u53c2:{}", (Object)JSON.toJSONString((Object)user));
        if (userDTOResponse == null || user == null) {
            return Response.createError((String)"\u5ba1\u6838\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        enterpriseVerifyDetailDTO.getVerifyMsg().setReviewer(user.getUserName());
        enterpriseVerifyDetailDTO.getVerifyMsg().setReviewDate(DateTimeFormatter.ofPattern("yyyy-MM-dd").format(LocalDate.now()));
        enterpriseVerifyDetailDTO.getVerifyMsg().setVerifyComments(Arrays.stream(rnrOrderDetails.getVerifyComments().split(",")).collect(Collectors.toList()));
        enterpriseVerifyDetailDTO.getVerifyMsg().setOtherComments(rnrOrderDetails.getComment());
        enterpriseVerifyDetailDTO.getVerifyMsg().setOrderStatus(rnrOrderDetails.getOrderStatus());
        log.warn("enterpriseVerifyDetailDTO\u56de\u53c2{}", JSON.toJSON((Object)enterpriseVerifyDetailDTO));
        return Response.createSuccess((Object)enterpriseVerifyDetailDTO);
    }
}

