/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.controller;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.dto.SimFileHistoryDTO;
import com.cusc.nirvana.user.rnr.mg.dto.SimFileHistoryQueryDTO;
import com.cusc.nirvana.user.rnr.mg.service.ISimFileHistoryService;
import com.cusc.nirvana.user.rnr.mg.service.impl.RnrOrderServiceImpl;
import com.cusc.nirvana.user.rnr.mg.validation.group.Delete;
import com.cusc.nirvana.user.rnr.mg.validation.group.Insert;
import com.cusc.nirvana.user.rnr.mg.validation.group.Update;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/simFileHistory"})
public class SimFileHistoryController {
    @Autowired
    private ISimFileHistoryService fileHistoryService;
    @Autowired
    private RnrOrderServiceImpl rnrOrderService;

    @PostMapping(value={"add"})
    public Response<SimFileHistoryDTO> add(@RequestBody @Validated(value={Insert.class}) SimFileHistoryDTO historyDTO) {
        historyDTO.setCreateTime(new Date());
        historyDTO = this.fileHistoryService.insert(historyDTO);
        return Response.createSuccess((Object)historyDTO);
    }

    @PostMapping(value={"update"})
    public Response<SimFileHistoryDTO> update(@RequestBody @Validated(value={Update.class}) SimFileHistoryDTO historyDTO) {
        historyDTO = this.fileHistoryService.update(historyDTO);
        return Response.createSuccess((Object)historyDTO);
    }

    @PostMapping(value={"delete"})
    public Response delete(@RequestBody @Validated(value={Delete.class}) SimFileHistoryDTO historyDTO) {
        boolean flag = this.fileHistoryService.deleteById(historyDTO.getOrgUuid(), historyDTO.getUuid());
        return Response.createSuccess((Object)flag);
    }

    @GetMapping(value={"getByUuid"})
    public Response<SimFileHistoryDTO> getByUuid(String uuid) {
        SimFileHistoryDTO historyDTO = this.fileHistoryService.getByUuid(uuid);
        return Response.createSuccess((Object)historyDTO);
    }

    @PostMapping(value={"queryByPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u67e5\u8be2")
    public Response<PageResult<SimFileHistoryDTO>> queryByPage(@RequestBody @Validated SimFileHistoryQueryDTO queryDTO) {
        PageResult historyDtos = this.fileHistoryService.queryByPage(queryDTO);
        return Response.createSuccess((Object)historyDtos);
    }
}

