/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.controller;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrRelationDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrRelationIccidDTO;
import com.cusc.nirvana.user.rnr.mg.service.IRnrRelationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rnr/relation"})
public class RnrRelationController {
    private static final Logger log = LoggerFactory.getLogger(RnrRelationController.class);
    @Autowired
    private IRnrRelationService rnrRelationService;

    @PostMapping(value={"/saveRnrRelation"})
    public Response saveRnrRelation(@RequestBody RnrRelationDTO bean) {
        return this.rnrRelationService.saveRnrRelation(bean);
    }

    @PostMapping(value={"/syncRnrRelation"})
    public Response syncRnrRelation(@RequestBody RnrRelationDTO bean) {
        return this.rnrRelationService.syncRnrRelation(bean);
    }

    @PostMapping(value={"/lockRnrIccidList"})
    public Response lockRnrIccidList(@RequestBody RnrRelationIccidDTO bean) {
        this.rnrRelationService.lockRnrIccidList(bean.getTenantNo(), bean.getIccidList(), bean.getValue());
        return Response.createSuccess();
    }

    @PostMapping(value={"/unLockRnrIccidList"})
    public Response unLockRnrIccidList(@RequestBody RnrRelationIccidDTO bean) {
        this.rnrRelationService.unLockRnrIccidList(bean.getTenantNo(), bean.getIccidList());
        return Response.createSuccess();
    }

    @PostMapping(value={"/checkIccidStatus"})
    public Response checkIccidStatus(@RequestBody RnrRelationIccidDTO bean) {
        log.info("checkIccidStatus \u88ab\u8bbf\u95ee\u4e86");
        this.rnrRelationService.checkIccidStatus(bean.getTenantNo(), bean.getIccidList());
        return Response.createSuccess();
    }

    @PostMapping(value={"/getRnrRelation"})
    public Response<RnrRelationDTO> getRnrRelation(@RequestBody MgRnrCardInfoDTO bean) {
        return this.rnrRelationService.getRnrRelation(bean);
    }
}

