/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.controller;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrOrderService;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mgRnrOrder"})
public class RnrOrderController {
    @Autowired
    private IRnrOrderService mgRnrOrderService;
    @Autowired
    private IMgRnrInfoService mgRnrInfoService;
    @Autowired
    private IMgRnrCardInfoService cardInfoService;

    @PostMapping(value={"/queryByPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u67e5\u8be2")
    public Response<PageResult<RnrOrderDTO>> queryByPage(@RequestBody RnrOrderDTO bean) {
        return Response.createSuccess((Object)this.mgRnrOrderService.queryByPage(bean));
    }

    @PostMapping(value={"/getByUuid"})
    public Response<RnrOrderDTO> getByUuid(@RequestBody RnrOrderDTO bean) {
        return Response.createSuccess((Object)this.mgRnrOrderService.getByUuid(bean));
    }

    @PostMapping(value={"/queryByList"})
    public Response<List<RnrOrderDTO>> queryByList(@RequestBody RnrOrderDTO bean) {
        return Response.createSuccess((Object)this.mgRnrOrderService.queryByList(bean));
    }

    @PostMapping(value={"/add"})
    public Response add(@RequestBody RnrOrderDTO bean) {
        return Response.createSuccess((Object)this.mgRnrOrderService.insert(bean));
    }

    @PostMapping(value={"/update"})
    public Response update(@RequestBody RnrOrderDTO bean) {
        return Response.createSuccess((Object)this.mgRnrOrderService.update(bean));
    }

    @PostMapping(value={"/deleteById"})
    public Response<Boolean> deleteById(@RequestBody RnrOrderDTO bean) {
        return Response.createSuccess((Object)this.mgRnrOrderService.deleteById(bean));
    }

    @PostMapping(value={"/startWorkOrder"})
    public Response startWorkOrder(@RequestBody RnrOrderDTO dto) {
        dto = this.mgRnrOrderService.getByUuid(dto);
        MgRnrInfoDTO mgRnrInfoDTO = new MgRnrInfoDTO();
        mgRnrInfoDTO.setUuid(dto.getRnrId());
        mgRnrInfoDTO = this.mgRnrInfoService.getByUuid(mgRnrInfoDTO);
        if (mgRnrInfoDTO == null) {
            throw new CuscUserException("", "\u67e5\u8be2\u5de5\u5355\u5bf9\u5e94\u4e1a\u52a1\u5931\u8d25");
        }
        MgRnrCardInfoDTO mgRnrCardInfoDTO = new MgRnrCardInfoDTO();
        mgRnrCardInfoDTO.setOrderId(dto.getUuid());
        mgRnrCardInfoDTO.setCurrPage(Integer.valueOf(1));
        mgRnrCardInfoDTO.setPageSize(Integer.valueOf(5));
        PageResult page = this.cardInfoService.queryByPage(mgRnrCardInfoDTO);
        this.mgRnrOrderService.sendOrderSystem(dto, mgRnrInfoDTO, page.getList());
        return Response.createSuccess();
    }

    @PostMapping(value={"/updateOrderStatus"})
    public Response updateOrderStatus(@RequestBody RnrOrderDTO dto) {
        ArrayList<String> orderIds = new ArrayList<String>();
        orderIds.add(dto.getUuid());
        this.mgRnrOrderService.updateOrderStatus(orderIds, dto.getOrderStatus().intValue());
        return Response.createSuccess((String)"\u66f4\u65b0\u5de5\u5355\u6210\u529f");
    }
}

