/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.controller;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.dto.IccIdListRequestDTO;
import com.cusc.nirvana.user.rnr.mg.dto.OrgSimRelBatchDTO;
import com.cusc.nirvana.user.rnr.mg.dto.OrgSimRelBindStatusDTO;
import com.cusc.nirvana.user.rnr.mg.dto.OrgSimRelDTO;
import com.cusc.nirvana.user.rnr.mg.dto.OrgSimRelQueryDTO;
import com.cusc.nirvana.user.rnr.mg.dto.OrgSimRelVinQueryDTO;
import com.cusc.nirvana.user.rnr.mg.service.IOrgSimRelService;
import com.cusc.nirvana.user.rnr.mg.validation.group.Delete;
import com.cusc.nirvana.user.rnr.mg.validation.group.Insert;
import com.cusc.nirvana.user.rnr.mg.validation.group.Update;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/orgSimRel"})
public class OrgSimRelController {
    @Autowired
    private IOrgSimRelService orgSimRelService;

    @PostMapping(value={"add"})
    public Response<OrgSimRelDTO> add(@RequestBody @Validated(value={Insert.class}) OrgSimRelDTO orgSimRelDTO) {
        orgSimRelDTO = this.orgSimRelService.insert(orgSimRelDTO);
        return Response.createSuccess((Object)orgSimRelDTO);
    }

    @PostMapping(value={"addBatch"})
    public Response<?> addBatch(@RequestBody OrgSimRelBatchDTO orgSimRelBatchDto) {
        Integer cnt = this.orgSimRelService.insertBatch(orgSimRelBatchDto.getOrgSimRels());
        return Response.createSuccess((Object)cnt);
    }

    @PostMapping(value={"update"})
    public Response<OrgSimRelDTO> update(@RequestBody @Validated(value={Update.class}) OrgSimRelDTO orgSimRelDTO) {
        orgSimRelDTO = this.orgSimRelService.update(orgSimRelDTO);
        return Response.createSuccess((Object)orgSimRelDTO);
    }

    @PostMapping(value={"delete"})
    public Response delete(@RequestBody @Validated(value={Delete.class}) OrgSimRelDTO orgSimRelDTO) {
        boolean flag = this.orgSimRelService.deleteById(orgSimRelDTO);
        return Response.createSuccess((Object)flag);
    }

    @PostMapping(value={"updateBindStatus"})
    public Response updateStatus(@RequestBody @Validated OrgSimRelBindStatusDTO simRelBindStatusDTO) {
        boolean flag = this.orgSimRelService.updateBindStatus(simRelBindStatusDTO.getIccid(), simRelBindStatusDTO.getVin(), simRelBindStatusDTO.getBindStatus());
        return Response.createSuccess((Object)flag);
    }

    @GetMapping(value={"getByUuid"})
    public Response<OrgSimRelDTO> getByUuid(String uuid) {
        OrgSimRelDTO orgSimRelDTO = this.orgSimRelService.getByUuid(uuid);
        return Response.createSuccess((Object)orgSimRelDTO);
    }

    @GetMapping(value={"getByIccid"})
    public Response<OrgSimRelDTO> getByIccid(String iccid) {
        OrgSimRelDTO orgSimRelDTO = this.orgSimRelService.getByIccid(iccid);
        return Response.createSuccess((Object)orgSimRelDTO);
    }

    @PostMapping(value={"queryByVin"})
    public Response<List<OrgSimRelDTO>> queryByVin(@RequestBody @Validated OrgSimRelVinQueryDTO queryDTO) {
        List list = this.orgSimRelService.queryByVin(queryDTO.getVin());
        return Response.createSuccess((Object)list);
    }

    @PostMapping(value={"queryByPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u67e5\u8be2")
    public Response<PageResult<OrgSimRelDTO>> queryByPage(@RequestBody @Validated OrgSimRelQueryDTO orgSimRelQueryDTO) {
        PageResult historyDtos = this.orgSimRelService.queryByPage(orgSimRelQueryDTO);
        return Response.createSuccess((Object)historyDtos);
    }

    @PostMapping(value={"queryByList"})
    @ApiOperation(value="\u67e5\u8be2\u591a\u4e2aiccid\u8be6\u60c5")
    Response<List<OrgSimRelDTO>> queryByList(@RequestBody @Validated IccIdListRequestDTO requestDTO) {
        return Response.createSuccess((Object)this.orgSimRelService.queryByList(requestDTO.getIccids()));
    }
}

