/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.controller;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.dto.OrgBusinessTagDTO;
import com.cusc.nirvana.user.rnr.mg.dto.OrgBusinessTagQueryDTO;
import com.cusc.nirvana.user.rnr.mg.service.IOrgBusinessTagService;
import com.cusc.nirvana.user.rnr.mg.validation.group.Delete;
import com.cusc.nirvana.user.rnr.mg.validation.group.Insert;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/businessTag"})
public class OrgBusinessTagController {
    @Autowired
    private IOrgBusinessTagService businessTagService;

    @PostMapping(value={"add"})
    public Response<OrgBusinessTagDTO> add(@RequestBody @Validated(value={Insert.class}) OrgBusinessTagDTO tagDTO) {
        Response response = this.businessTagService.insert(tagDTO);
        return response;
    }

    @PostMapping(value={"update"})
    public Response<OrgBusinessTagDTO> update(@RequestBody @Validated(value={Insert.class}) OrgBusinessTagDTO tagDTO) {
        Response response = this.businessTagService.update(tagDTO);
        return response;
    }

    @PostMapping(value={"delete"})
    public Response delete(@RequestBody @Validated(value={Delete.class}) OrgBusinessTagDTO tagDTO) {
        Response response = this.businessTagService.remove(tagDTO.getUuid());
        return response;
    }

    @GetMapping(value={"getByUuid"})
    public Response<OrgBusinessTagDTO> getByUuid(String uuid) {
        Response response = this.businessTagService.getByUuid(uuid);
        return response;
    }

    @PostMapping(value={"query"})
    @ApiOperation(value="\u6807\u7b7e\u4fe1\u606f\u5217\u8868\u67e5\u8be2", notes="\u6807\u7b7e\u4fe1\u606f\u5217\u8868\u67e5\u8be2")
    public Response<List<OrgBusinessTagDTO>> query(@RequestBody @Validated OrgBusinessTagQueryDTO queryDto) {
        Response response = this.businessTagService.query(queryDto.getTenantNo(), queryDto.getOrgUuid());
        return response;
    }
}

