/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.controller;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.RnrResponseCode;
import com.cusc.nirvana.user.rnr.mg.dto.MgSecretKeyDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgSecretKeyService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mgSecretKey"})
public class MgSecretKeyController {
    @Autowired
    private IMgSecretKeyService mgSecretKeyService;

    @PostMapping(value={"/queryByPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u67e5\u8be2")
    public Response<PageResult<MgSecretKeyDTO>> queryByPage(@RequestBody MgSecretKeyDTO bean) {
        return Response.createSuccess((Object)this.mgSecretKeyService.queryByPage(bean));
    }

    @PostMapping(value={"/getByUuid"})
    public Response<MgSecretKeyDTO> getByUuid(@RequestBody MgSecretKeyDTO bean) {
        return Response.createSuccess((Object)this.mgSecretKeyService.getByUuid(bean));
    }

    @PostMapping(value={"/queryByList"})
    public Response<List<MgSecretKeyDTO>> queryByList(@RequestBody MgSecretKeyDTO bean) {
        return Response.createSuccess((Object)this.mgSecretKeyService.queryByList(bean));
    }

    @PostMapping(value={"/add"})
    public Response add(@RequestBody MgSecretKeyDTO bean) {
        return Response.createSuccess((Object)this.mgSecretKeyService.insert(bean));
    }

    @PostMapping(value={"/update"})
    public Response update(@RequestBody MgSecretKeyDTO bean) {
        return Response.createSuccess((Object)this.mgSecretKeyService.update(bean));
    }

    @PostMapping(value={"/deleteById"})
    public Response<Boolean> deleteById(@RequestBody MgSecretKeyDTO bean) {
        return Response.createSuccess((Object)this.mgSecretKeyService.deleteById(bean));
    }

    @PostMapping(value={"/getByTenantNoAndOrgan"})
    public Response<MgSecretKeyDTO> getByTenantNoAndOrgan(@RequestBody MgSecretKeyDTO bean) {
        if (CuscStringUtils.isEmpty((String)bean.getTenantNo())) {
            return Response.createError((String)RnrResponseCode.INVALID_DATA.getDescription());
        }
        return Response.createSuccess((Object)this.mgSecretKeyService.getByTenantNoAndOrgan(bean));
    }
}

