/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.controller;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardInfoService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mgRnrCardInfo"})
public class MgRnrCardInfoController {
    @Autowired
    private IMgRnrCardInfoService mgRnrCardInfoService;

    @PostMapping(value={"/queryByPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u67e5\u8be2")
    public Response<PageResult<MgRnrCardInfoDTO>> queryByPage(@RequestBody MgRnrCardInfoDTO bean) {
        return Response.createSuccess((Object)this.mgRnrCardInfoService.queryByPage(bean));
    }

    @PostMapping(value={"/queryPageByUserId"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u67e5\u8be2")
    public Response<PageResult<MgRnrCardInfoDTO>> queryPageByUserId(@RequestBody MgRnrCardInfoDTO bean) {
        return Response.createSuccess((Object)this.mgRnrCardInfoService.queryPageByUserId(bean));
    }

    @PostMapping(value={"/getByUuid"})
    public Response<MgRnrCardInfoDTO> getByUuid(@RequestBody MgRnrCardInfoDTO bean) {
        return Response.createSuccess((Object)this.mgRnrCardInfoService.getByUuid(bean));
    }

    @PostMapping(value={"/queryByList"})
    public Response<List<MgRnrCardInfoDTO>> queryByList(@RequestBody MgRnrCardInfoDTO bean) {
        return Response.createSuccess((Object)this.mgRnrCardInfoService.queryByList(bean));
    }

    @PostMapping(value={"/queryBindListByVin"})
    public Response<List<MgRnrCardInfoDTO>> queryBindListByVin(@RequestBody MgRnrCardInfoDTO bean) {
        return Response.createSuccess((Object)this.mgRnrCardInfoService.queryBindListByVin(bean.getIotId()));
    }

    @PostMapping(value={"/getBindsByVinsAndIccids"})
    public Response<List<MgRnrCardInfoDTO>> queryBindListByVinsAndIccids(@RequestBody MgRnrCardInfoDTO bean) {
        return Response.createSuccess((Object)this.mgRnrCardInfoService.queryBindListByVinsAndIccids(bean.getVinList(), bean.getIccidList()));
    }

    @PostMapping(value={"/queryBindListByVinAndBizType"})
    public Response<List<MgRnrCardInfoDTO>> queryBindListByVinAndBizType(@RequestBody MgRnrCardInfoDTO bean) {
        return Response.createSuccess((Object)this.mgRnrCardInfoService.queryBindListByVinAndBizType(bean.getIotId(), bean.getRnrBizzType().intValue()));
    }

    @PostMapping(value={"/queryListByVin"})
    public Response<List<MgRnrCardInfoDTO>> queryListByVin(@RequestBody MgRnrCardInfoDTO bean) {
        return Response.createSuccess((Object)this.mgRnrCardInfoService.queryListByVin(bean.getIotId()));
    }

    @PostMapping(value={"/add"})
    public Response add(@RequestBody MgRnrCardInfoDTO bean) {
        return Response.createSuccess((Object)this.mgRnrCardInfoService.insert(bean));
    }

    @PostMapping(value={"/update"})
    public Response update(@RequestBody MgRnrCardInfoDTO bean) {
        return Response.createSuccess((Object)this.mgRnrCardInfoService.update(bean));
    }

    @PostMapping(value={"/deleteById"})
    public Response<Boolean> deleteById(@RequestBody MgRnrCardInfoDTO bean) {
        return Response.createSuccess((Object)this.mgRnrCardInfoService.deleteById(bean));
    }

    @PostMapping(value={"/checkStatus"})
    public Response<Boolean> checkStatus(@RequestBody MgRnrCardInfoDTO bean) {
        return Response.createSuccess((Object)this.mgRnrCardInfoService.checkIccid(bean));
    }

    @PostMapping(value={"/getOneByIccid"})
    public Response getOneByIccid(@RequestBody MgRnrCardInfoDTO bean) {
        return Response.createSuccess((Object)this.mgRnrCardInfoService.getOneByIccid(bean));
    }

    @PostMapping(value={"/updateBeans"})
    public Response updateCardStatus(@RequestBody List<MgRnrCardInfoDTO> beans) {
        return Response.createSuccess((Object)this.mgRnrCardInfoService.updateBatchCardStatus(beans));
    }

    @PostMapping(value={"/updateCardStatusByRnrId"})
    public Response updateCardStatusByRnrId(@RequestBody MgRnrCardInfoDTO dto) {
        this.mgRnrCardInfoService.updateCardStatusByRnrId(dto);
        return Response.createSuccess();
    }

    @PostMapping(value={"/insertBeans"})
    public Response insertBeans(@RequestBody List<MgRnrCardInfoDTO> beans) {
        return Response.createSuccess((Object)this.mgRnrCardInfoService.insertBatchCards(beans));
    }

    @PostMapping(value={"/sendCardNotice"})
    public Response sendCardNotice(@RequestBody MgRnrCardInfoDTO dto) {
        this.mgRnrCardInfoService.sendCardNotice(dto);
        return Response.createSuccess();
    }

    @PostMapping(value={"/getNumWithUnload"})
    public Response getNumWithUnload(@RequestBody MgRnrInfoDTO dto) {
        int num = this.mgRnrCardInfoService.getNumWithUnload(dto);
        return Response.createSuccess((Object)num);
    }
}

