/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.common.handler;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.exception.CuscUserException;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
@Order(value=0)
public class RnrMgExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RnrMgExceptionHandler.class);

    @ExceptionHandler(value={CuscUserException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public Response<?> cuscUserHandler(CuscUserException e) {
        LOGGER.warn("cuscRnrHandler Handler code: {}, msg: {}", (Object)e.getCode(), (Object)e.getMessage());
        return Response.createError((String)e.getMessage(), (String)e.getCode());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Response validExceptionHandle(Exception ex) {
        String message;
        if (ex instanceof BindException) {
            BindException bingException = (BindException)ex;
            message = ((ObjectError)bingException.getAllErrors().get(0)).getDefaultMessage();
        } else if (ex instanceof HttpMessageNotReadableException) {
            HttpMessageNotReadableException notReadableException = (HttpMessageNotReadableException)ex;
            message = notReadableException.getMessage();
        } else if (ex instanceof ConstraintViolationException) {
            ConstraintViolationException validationException = (ConstraintViolationException)ex;
            Set violationErrors = validationException.getConstraintViolations();
            ConstraintViolation error = (ConstraintViolation)violationErrors.iterator().next();
            message = error.getMessage();
        } else if (ex instanceof HttpRequestMethodNotSupportedException) {
            HttpRequestMethodNotSupportedException methodNotSupportedException = (HttpRequestMethodNotSupportedException)ex;
            message = methodNotSupportedException.getMessage();
        } else {
            message = "\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01";
        }
        LOGGER.error(message, (Throwable)ex);
        return Response.createError((String)message);
    }
}

