/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.common.cloud;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Sm4DemoUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Sm4DemoUtils.class);
    public static final String ALGORITHM_NAME = "SM4";
    public static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS5Padding";

    private Sm4DemoUtils() {
    }

    public static String encryptEcbPaddingHexString(String key, String data) {
        return Sm4DemoUtils.encryptEcbPaddingHex((String)key, (String)data, (boolean)true, null);
    }

    public static String decryptEcbPaddingString(String key, String data) {
        return Sm4DemoUtils.decryptEcbPaddingHex((String)key, (String)data, (boolean)true, null);
    }

    public static String decryptEcbPaddingHex(String key, String data, boolean hexString, String charset) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        try {
            byte[] keyBytes = hexString ? Sm4DemoUtils.hexStringToBytes((String)key) : key.getBytes();
            byte[] decrypted = Sm4DemoUtils.decryptEcbPaddingByte((byte[])keyBytes, (byte[])Sm4DemoUtils.base64Decoder((String)data));
            if (StringUtils.isNotEmpty((CharSequence)charset)) {
                return new String(decrypted, charset);
            }
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Sm4Util.decryptEcbPaddingHex error ! ", (Throwable)e);
            return null;
        }
    }

    private static byte[] decryptEcbPaddingByte(byte[] key, byte[] cipherText) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Cipher cipher = Sm4DemoUtils.generateEcbCipher((String)"SM4/ECB/PKCS5Padding", (int)2, (byte[])key);
        return cipher.doFinal(cipherText);
    }

    private static String encryptEcbPaddingHex(String key, String data, boolean hexString, String charset) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        try {
            byte[] keyBytes = hexString ? Sm4DemoUtils.hexStringToBytes((String)key) : key.getBytes();
            byte[] dataBytes = StringUtils.isNotEmpty((CharSequence)charset) ? data.getBytes(charset) : data.getBytes(StandardCharsets.UTF_8);
            byte[] encrypted = Sm4DemoUtils.encryptEcbPaddingByte((byte[])keyBytes, (byte[])dataBytes);
            return Sm4DemoUtils.base64Encoder((byte[])encrypted);
        }
        catch (Exception e) {
            LOGGER.error("Sm4Util.encryptEcbPaddingHex error ! ", (Throwable)e);
            return null;
        }
    }

    private static String base64Encoder(byte[] encrypted) {
        return Base64.getEncoder().encodeToString(encrypted);
    }

    private static byte[] base64Decoder(String encrypted) throws IOException {
        return Base64.getDecoder().decode(encrypted);
    }

    private static byte[] encryptEcbPaddingByte(byte[] key, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Sm4DemoUtils.generateEcbCipher((String)"SM4/ECB/PKCS5Padding", (int)1, (byte[])key);
        return cipher.doFinal(data);
    }

    private static Cipher generateEcbCipher(String algorithmName, int mode, byte[] key) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, "SM4");
        cipher.init(mode, sm4Key);
        return cipher;
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(Sm4DemoUtils.charToByte((char)hexChars[pos]) << 4 | Sm4DemoUtils.charToByte((char)hexChars[pos + 1]));
        }
        return d;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

