/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.common.cloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.cusc.nirvana.common.encrypt.sign.HMAC;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.common.cloud.CloudConstant;
import com.cusc.nirvana.user.rnr.common.cloud.Sm4DemoUtils;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CloudService<T> {
    private static final Logger log = LoggerFactory.getLogger(CloudService.class);
    @Resource
    private RestTemplate thirdPartyRnr;
    @Autowired
    private CloudConstant cloudConstant;

    public <T> Response<T> postForResponse(String url, Object rq, Class<T> rsClazz) {
        String rqUrl = this.cloudConstant.getHOST() + url;
        try {
            log.info("openapi key : {}", (Object)this.cloudConstant.getENCRYPT_KEY());
            String encryptrq = Sm4DemoUtils.encryptEcbPaddingHexString((String)this.cloudConstant.getENCRYPT_KEY(), (String)JSON.toJSONString((Object)rq));
            HttpHeaders headers = this.headers();
            HttpEntity httpEntity = new HttpEntity((Object)encryptrq, (MultiValueMap)headers);
            log.info("send 2 cloud begin , url : {}, rq : {}, header : {}, encryptrq : {}", new Object[]{rqUrl, JSON.toJSONString((Object)rq), headers.toString(), encryptrq});
            long startTime = System.currentTimeMillis();
            ResponseEntity entity = this.thirdPartyRnr.exchange(rqUrl, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            long endTime = System.currentTimeMillis();
            if (entity != null && entity.getStatusCodeValue() == 200) {
                log.info("send 2 cloud success code 200, url : {}, rq : {}, body : {}, times : {}", new Object[]{rqUrl, JSON.toJSONString((Object)rq), entity.getBody(), endTime - startTime});
                Response result = (Response)JSON.parseObject((String)((String)entity.getBody()), (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (Feature[])new Feature[0]);
                String data = Sm4DemoUtils.decryptEcbPaddingString((String)this.cloudConstant.getDECRYPT_KEY(), (String)((String)result.getData()));
                Object t = JSON.parseObject((String)data, rsClazz);
                Response finalresult = new Response(result.getMsg(), result.getCode(), t, result.getSuccess(), result.getException());
                finalresult.setAttachment(result.getAttachment());
                return finalresult;
            }
            log.info("send 2 cloud fail, url : {}, rq : {}, times : {}, entity : {}", new Object[]{rqUrl, JSON.toJSONString((Object)rq), endTime - startTime, null == entity ? null : JSON.toJSONString((Object)entity)});
            return Response.createError((String)"\u7f51\u7edc\u5f02\u5e38");
        }
        catch (Exception e) {
            log.error("send 2 cloud error, url : {}, rq : {}, e : {}", new Object[]{rqUrl, JSON.toJSONString((Object)rq), e});
            return Response.createError((String)"\u7cfb\u7edf\u5f02\u5e38");
        }
    }

    public <T> Response<List<T>> postForResponseList(String url, Object rq, Class<T> rsClazz) {
        String rqUrl = this.cloudConstant.getHOST() + url;
        try {
            HttpEntity httpEntity = new HttpEntity((Object)Sm4DemoUtils.encryptEcbPaddingHexString((String)this.cloudConstant.getENCRYPT_KEY(), (String)JSON.toJSONString((Object)rq)), (MultiValueMap)this.headers());
            log.info("send 2 cloud begin , url : {}, rq : {}", (Object)rqUrl, (Object)JSON.toJSONString((Object)rq));
            long startTime = System.currentTimeMillis();
            ResponseEntity entity = this.thirdPartyRnr.exchange(rqUrl, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            long endTime = System.currentTimeMillis();
            if (entity != null && entity.getStatusCodeValue() == 200) {
                log.info("send 2 cloud success code 200, url : {}, rq : {}, body : {}, times : {}", new Object[]{rqUrl, JSON.toJSONString((Object)rq), entity.getBody(), endTime - startTime});
                Response result = (Response)JSON.parseObject((String)((String)entity.getBody()), (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (Feature[])new Feature[0]);
                String data = Sm4DemoUtils.decryptEcbPaddingString((String)this.cloudConstant.getDECRYPT_KEY(), (String)((String)result.getData()));
                List t = JSON.parseArray((String)data, rsClazz);
                Response finalresult = new Response(result.getMsg(), result.getCode(), (Object)t, result.getSuccess(), result.getException());
                finalresult.setAttachment(result.getAttachment());
                return finalresult;
            }
            log.info("send 2 cloud fail, url : {}, rq : {}, times : {}, entity : {}", new Object[]{rqUrl, JSON.toJSONString((Object)rq), endTime - startTime, null == entity ? null : JSON.toJSONString((Object)entity)});
            return Response.createError((String)"\u7f51\u7edc\u5f02\u5e38");
        }
        catch (Exception e) {
            log.error("send 2 cloud error, url : {}, rq : {}, e : {}", new Object[]{rqUrl, JSON.toJSONString((Object)rq), e});
            return Response.createError((String)"\u7cfb\u7edf\u5f02\u5e38");
        }
    }

    public HttpHeaders headers() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("APPID", this.cloudConstant.getAPPID());
        httpHeaders.add("NONCE_STR", CuscStringUtils.generateUuid());
        httpHeaders.add("TIMESTAMP", String.valueOf(System.currentTimeMillis()));
        httpHeaders.add("VERSION", this.cloudConstant.getVERSION());
        httpHeaders.setContentType(MediaType.parseMediaType((String)"application/json; charset=UTF-8"));
        StringBuilder sb = new StringBuilder();
        sb.append("APPID" + this.cloudConstant.getAPPID());
        sb.append("NONCE_STR" + (String)httpHeaders.get((Object)"NONCE_STR").get(0));
        sb.append("TIMESTAMP" + (String)httpHeaders.get((Object)"TIMESTAMP").get(0));
        sb.append("VERSION" + (String)httpHeaders.get((Object)"VERSION").get(0));
        String scret = HMAC.sign((String)sb.toString(), (String)this.cloudConstant.getAPPSCRET(), (HMAC.Type)HMAC.Type.HmacSHA256);
        httpHeaders.add("SIGN", scret);
        return httpHeaders;
    }
}

