package com.cusc.nirvana.user.rnr.mg.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.SimFileHistoryDTO;
import com.cusc.nirvana.user.rnr.mg.dto.SimFileHistoryQueryDTO;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class SimFileHistoryClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    RestTemplate restTemplateRnrMg;

    /**
     * 新增SIM卡导入历史信息
     * @param bean
     * @return
     */
    public Response<SimFileHistoryDTO> add(SimFileHistoryDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/simFileHistory/add", bean, SimFileHistoryDTO.class);
    }

    /**
     * 修改SIM卡导入历史信息
     * @param bean
     * @return
     */
    public Response<SimFileHistoryDTO> update(SimFileHistoryDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/simFileHistory/update", bean, SimFileHistoryDTO.class);
    }

    /**
     * 删除SIM卡导入历史信息
     * @param bean
     * @return
     */
    public Response delete(SimFileHistoryDTO bean) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/simFileHistory/delete", bean, Response.class);
    }

    /**
     * 查询指定数据
     * @param uuid
     * @return
     */
    public Response<SimFileHistoryDTO> getByUuid(String uuid) {
        Response response = restTemplateRnrMg.getForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/simFileHistory/getByUuid?uuid=" + uuid, Response.class);
        return Response.createSuccess(JSON.parseObject(JSONObject.toJSONString(response.getData()), SimFileHistoryDTO.class));
    }

    /**
     * 分页查询历史数据
     * @param bean
     * @return
     */
    public Response<PageResult<SimFileHistoryDTO>> queryByPage(SimFileHistoryQueryDTO bean) {
        return RnrMgRestTemplateUtils.postForResponsePageResult(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/simFileHistory/queryByPage", bean, SimFileHistoryDTO.class);
    }

}
