package com.cusc.nirvana.user.rnr.mg.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.OrgBusinessTagDTO;
import com.cusc.nirvana.user.rnr.mg.dto.OrgBusinessTagQueryDTO;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

@Component
public class OrgBusinessTagClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    RestTemplate restTemplateRnrMg;

    /**
     * 新增业务标签信息
     *
     * @param bean
     * @return
     */
    public Response<OrgBusinessTagDTO> add(OrgBusinessTagDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/businessTag/add", bean, OrgBusinessTagDTO.class);
    }

    /**
     * 修改业务标签信息
     *
     * @param bean
     * @return
     */
    public Response<OrgBusinessTagDTO> update(OrgBusinessTagDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/businessTag/update", bean, OrgBusinessTagDTO.class);
    }

    /**
     * 删除业务标签信息
     *
     * @param bean
     * @return
     */
    public Response delete(OrgBusinessTagDTO bean) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/businessTag/delete", bean,
                Response.class);
    }

    /**
     * 查询指定数据
     *
     * @param uuid
     * @return
     */
    public Response<OrgBusinessTagDTO> getByUuid(String uuid) {
        return RnrMgRestTemplateUtils.getForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL +
                "/businessTag/getByUuid?uuid=" + uuid, OrgBusinessTagDTO.class);
    }

    /**
     * 根据租户和标签编码查询业务标签信息
     *
     * @param bean
     * @return
     */
    public Response<OrgBusinessTagDTO> getByTagCode(OrgBusinessTagDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/businessTag/getByTagCode", bean, OrgBusinessTagDTO.class);
    }

    /**
     * 分页查询历史数据
     *
     * @param queryDTO
     * @return
     */
    public Response<List<OrgBusinessTagDTO>> query(OrgBusinessTagQueryDTO queryDTO) {
        return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/businessTag/query", queryDTO, OrgBusinessTagDTO.class);
    }

}
