package com.cusc.nirvana.user.rnr.mg.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.MgCardNoticeDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrRelationDTO;
import com.cusc.nirvana.user.rnr.mg.dto.SurplusConfirmDto;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * @author yubo
 * @since 2022-04-19 20:14
 */
@Component
public class MgSurplusBindClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    private RestTemplate restTemplateRnrMg;

    /**
     * 保存一车多卡信息
     *
     * @param bean
     * @return
     */
    public Response<String> saveSurplusRnrRelation(RnrRelationDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/rnr/surplusBind/saveRnrRelation", bean, String.class);
    }

    /**
     * 一车多卡短信确认
     *
     * @param bean
     * @return
     */
    public Response<Boolean> surplusConfirm(SurplusConfirmDto bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/rnr/surplusBind/confirm", bean, Boolean.class);
    }

    /**
     * 特殊业务短信回调成功 发送mq
     *
     */
    public Response sendMQ(List<MgCardNoticeDTO> beans) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/rnr/surplusBind/sendMQ", beans, Boolean.class);
    }
}
