package com.cusc.nirvana.user.rnr.mg.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.RnrRelationDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrUnbindDTO;
import com.cusc.nirvana.user.rnr.mg.dto.VehicleUnbindDTO;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * 实名卡解绑
 *
 * @author yuy336
 * @since 2022-03-04 11:06:53
 */
@Component
public class MgRnrUnboundClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    private RestTemplate restTemplateRnrMg;

    /**
     * 解绑
     *
     * @param bean 解绑信息
     */
    public Response rnrUnbound(RnrUnbindDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/unbound/rnrUnbound", bean, Object.class);
    }

    /**
     * 批量解绑
     *
     * @param bean
     * @return
     */
    public Response batchUnbound(VehicleUnbindDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/unbound/batchUnbound", bean, Object.class);
    }

    /**
     * 二手车解绑
     *
     * @param bean
     * @return
     */
    public Response secondHandUnBound(RnrRelationDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/unbound/secondHandUnBound", bean, Object.class);
    }
}
