package com.cusc.nirvana.user.rnr.mg.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrRelationDTO;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * @author yubo
 * @since 2022-04-19 20:14
 */
@Component
public class MgRnrRelationClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    private RestTemplate restTemplateRnrMg;

    /**
     * 保存实名信息
     *
     * @param bean
     * @return
     */
    public Response saveRnrRelation(RnrRelationDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/rnr/relation/saveRnrRelation", bean, Object.class);
    }


    /**
     * 保存实名信息
     *
     * @param bean
     * @return
     */
    public Response syncRnrRelation(RnrRelationDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/rnr/relation/syncRnrRelation", bean, Object.class);
    }


    /**
     *  根据iccid获取部分开户信息
     *
     * @param bean
     * @return
     */
    public Response<RnrRelationDTO> getRnrRelation(MgRnrCardInfoDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/rnr/relation/getRnrRelation", bean, RnrRelationDTO.class);
    }

    /**
     * 修改换件实名信息
     *
     * @param bean
     * @return
     */
    public Response updateChangeBindingRelation(RnrRelationDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/rnr/relation/updateChangeBindingRelation", bean, Object.class);
    }

    /**
     * 保存实名信息
     *
     * @param bean
     * @return
     */
    public Response jfSaveRnrRelation(RnrRelationDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/rnr/relation/jfSaveRnrRelation", bean, Object.class);
    }
}
