package com.cusc.nirvana.user.rnr.mg.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.*;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.apache.catalina.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

import java.util.List;
import java.util.Map;

/**
 * 实名卡信息(RnrCardInfo) client
 *
 * @author yuy336
 * @since 2022-03-04 11:06:53
 */
@Component
public class MgRnrCardInfoClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    private RestTemplate restTemplateRnrMg;

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<MgRnrCardInfoDTO>> queryByPage(MgRnrCardInfoDTO bean) {
        return RnrMgRestTemplateUtils.postForResponsePageResult(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/queryByPage", bean, MgRnrCardInfoDTO.class);
    }

    /**
     * 通过用户id查询card信息分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<MgRnrCardInfoDTO>> queryPageByUserId(MgRnrCardInfoDTO bean) {
        return RnrMgRestTemplateUtils.postForResponsePageResult(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/queryPageByUserId", bean, MgRnrCardInfoDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<MgRnrCardInfoDTO> getByUuid(MgRnrCardInfoDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/getByUuid",
                bean,
                MgRnrCardInfoDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<MgRnrCardInfoDTO>> queryByList(MgRnrCardInfoDTO bean) {
        return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/queryByList", bean,
                MgRnrCardInfoDTO.class);
    }

    /**
     * 通过iccid或vin查询数据
     */
    public Response<List<MgRnrCardInfoDTO>> queryByIccidOrVin(MgRnrCardInfoDTO bean) {
        return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/queryByIccidOrVin", bean,
                MgRnrCardInfoDTO.class);
    }

    /**
     * 通过vin查询iccid list
     */
    public Response<List<MgRnrCardInfoDTO>> queryBindListByVin(MgRnrCardInfoDTO bean) {
        return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/queryBindListByVin", bean,
                MgRnrCardInfoDTO.class);
    }

    /**
     * 通过vin查询iccid list
     */
    public Response<List<MgRnrCardInfoDTO>> queryBindListByVinsAndIccids(MgRnrCardInfoDTO bean) {
        return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/getBindsByVinsAndIccids", bean,
                MgRnrCardInfoDTO.class);
    }

    /**
     * 通过vin查询list
     */
    public Response<List<MgRnrCardInfoDTO>> queryListByVin(MgRnrCardInfoDTO bean) {
        return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/queryListByVin", bean,
                MgRnrCardInfoDTO.class);
    }

    /**
     * 通过vin和业务状态 查询list
     */
    public Response<List<MgRnrCardInfoDTO>> queryBindListByVinAndBizType(MgRnrCardInfoDTO bean) {
        return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/queryBindListByVinAndBizType", bean,
                MgRnrCardInfoDTO.class);
    }


    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<MgRnrCardInfoDTO> getOneByIccid(MgRnrCardInfoDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/getOneByIccid", bean,
                MgRnrCardInfoDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response add(MgRnrCardInfoDTO bean) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/add", bean, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    public Response update(MgRnrCardInfoDTO bean) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/update", bean, Response.class);
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<Boolean> deleteById(MgRnrCardInfoDTO bean) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/deleteById", bean, Response.class);
    }

    /**
     * 校验数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<Boolean> checkStatus(MgRnrCardInfoDTO bean) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/checkStatus", bean, Response.class);
    }

    /**
     * 批量更改卡绑定状态
     *
     * @param
     * @return 删除是否成功
     */
    public Response<Boolean> updateBatch(List<MgRnrCardInfoDTO> beans) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/updateBeans", beans, Response.class);
    }

    public Response updateCardStatusByRnrId(@RequestBody MgRnrCardInfoDTO dto) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/updateCardStatusByRnrId", dto, Response.class);
    }

    /**
     * 批量插入卡
     *
     * @param
     * @return 删除是否成功
     */
    public Response<Boolean> insertBatch(List<MgRnrCardInfoDTO> beans) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/insertBeans", beans, Response.class);
    }

    /**
     * 卡发送通知
     *
     * @param dto
     * @return
     */
    public Response sendCardNotice(MgRnrCardInfoDTO dto) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/sendCardNotice", dto, Response.class);
    }

    /**
     * 获取本地已实名未上报的数量
     *
     * @param bean
     * @return
     */
    public Response<Integer> getNumWithUnload(MgRnrInfoDTO bean) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/getNumWithUnload", bean, Response.class);
    }

    /**
     * 修改解绑信息
     *
     * @author zitan.ren
     */
    public Response carRnrUnbound(CarRnrUnboundDTO dto) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/unbound/carRnrUnbound", dto, Response.class);
    }

    /**
     * 解放汽车解绑
     *
     * @author windyHu
     */
    public Response jfCarRnrUnbound(JFUnbindDTO jfUnbindDTO) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/unbound/jfCarRnrUnbound", jfUnbindDTO, Response.class);
    }

    /**
     * 查询实名信息
     *
     * @author zitan.ren
     */
    public Response<MgRnrCardInfoDTO> queryCarInfo(MgRnrCardInfoDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/queryCarInfo", bean,
                MgRnrCardInfoDTO.class);
    }

    /**
     * 换件
     *
     * @author zitan.ren
     */
    public Response apiRnrCardInfoChange(ApiMgRnrCardInfoChangeDTO bean) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/apiRnrCardInfoChange", bean,
                Response.class);
    }

    /**
     * 换件
     *
     * @author zitan.ren
     */
    public Response<ApiMgRnrCardInfoChangeDTO> checkVinIccid(ApiMgRnrCardInfoChangeDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/checkVinIccid", bean,
                ApiMgRnrCardInfoChangeDTO.class);
    }

    /**
     * 通过vin查询list
     */
    public Response<List<MgRnrCardInfoDTO>> getListByIccid(MgRnrCardInfoDTO bean) {
        return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/getListByIccid", bean,
                MgRnrCardInfoDTO.class);
    }

    public Response<List<MgRnrCardInfoDTO>> getByVinAndIccid(MgRnrCardInfoDTO bean) {
        return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/getByVinAndIccid", bean,
                MgRnrCardInfoDTO.class);
    }


    /**
     * t1补数据
     *
     * @param
     * @return
     */
    public Response synchronousData(Map<String, Integer> sizeMap) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/rnr/synchronousData", sizeMap, Response.class);
    }

    /**
     * 查询大众总数
     *
     * @author zitan.ren
     */
    public Response totalData(TotalDataDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/total/count", bean,
                Integer.class);
    }

    /**
     * 修改实名状态
     *
     * @author zitan.ren
     */
    public Response updateRnrStatus(@RequestBody MgRnrCardInfoDTO dto) {
        return RnrMgRestTemplateUtils.postForObject(restTemplateRnrMg,UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCardInfo/updateRnrStatus", dto, Response.class);
    }
}
