package com.cusc.nirvana.user.rnr.mg.client;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.common.BaseApiFawRnrUrlDTO;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;

/**
 * H5页面地址
 */
@Component
public class FawRnrUrlClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    private RestTemplate restTemplateRnrMg;

  

    /**
     * H5页面地址查询
     * @param dto
     * @return
     */
    public Response findFawRnrUrl(@RequestBody BaseApiFawRnrUrlDTO dto){
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgFawRnrUrl/findFawRnrUrl", dto, Response.class);
    }
}
