package com.cusc.nirvana.user.rnr.mg.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * 解绑/换卡 部分操作 client
 */
@Component
public class ChangeOrUnbindIccidsClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    private RestTemplate restTemplateRnrMg;

    /**
     * 向mq发消息
     */
    public Response<Boolean> sendMSMToMQ(RnrOrderDTO beans) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/changeOrUnbin/sendMQ", beans,
                Response.class);
    }
}
