package com.cusc.nirvana.user.rnr.common.config;

import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.IOException;

/**
 * RestTemplate 拦截器
 *
 * @author zitan.ren
 * @date 2022/11/22 12:36
 */
@Slf4j
public class LoggingHttpRequestInterceptor implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext httpContext) throws HttpException, IOException {
        Object attribute = httpContext.getAttribute("http.target_host");
        log.info("restTemplateRnrMg ip :{}", attribute);
    }
//    @Override
//    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
//        Object attribute = httpContext.getAttribute("http.target_host");
//        log.info("restTemplateRnrFp ip :{}", attribute);
//    }
//    @Override
//    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
//        long start = System.currentTimeMillis();
//        ClientHttpResponse response = execution.execute(request, body);
//        log.info("RestTemplateRnrFp host : {}, body : {}, cost : {}", request.getURI().getHost(),new String(body, "utf-8"),System.currentTimeMillis()-start);
//        return response;
//    }
}
