/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.common.config;

import com.cusc.nirvana.user.rnr.common.config.RnrMgHttpPoolConfig;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateRnrMgConfig {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateRnrMgConfig.class);
    @Autowired
    private RnrMgHttpPoolConfig httpPoolConstants;

    @Bean(name={"restTemplateRnrMg"})
    @LoadBalanced
    public RestTemplate restTemplateRnrMg() {
        return this.getRestTemplateRnrMg();
    }

    public RestTemplate getRestTemplateRnrMg() {
        return new RestTemplate(this.httpRequestFactoryRnrMg());
    }

    private ClientHttpRequestFactory httpRequestFactoryRnrMg() {
        return new HttpComponentsClientHttpRequestFactory(this.httpClientRnrMg());
    }

    private HttpClient httpClientRnrMg() {
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(this.httpPoolConstants.getMaxTotal().intValue());
        connectionManager.setDefaultMaxPerRoute(this.httpPoolConstants.getDefaultMaxPerRoute().intValue());
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.httpPoolConstants.getSocketTimeout().intValue()).setConnectTimeout(this.httpPoolConstants.getConnectTimeout().intValue()).setConnectionRequestTimeout(this.httpPoolConstants.getConnectionRequestTimeout().intValue()).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).evictExpiredConnections().evictIdleConnections((long)this.httpPoolConstants.getMaxIdleTime().intValue(), TimeUnit.SECONDS).build();
    }
}

