package com.cusc.nirvana.user.rnr.mg.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.lang.reflect.Type;
import java.util.List;

/**
 * @author jiamj
 * @date 2022/3/9
 */
public class RestUtils {
    public static <T> Response<T> rest(RestTemplate restTemplate, String url, Object request, Class<?> responseType) {
        ResponseEntity<String> entity = restTemplate.postForEntity(url, request, String.class);
        return JSON.parseObject(entity.getBody(), (new TypeReference<Response<T>>(new Type[]{responseType}) {
        }).getType(), new Feature[0]);
    }

    public static <T> Response<PageResult<T>> restPageResult(RestTemplate restTemplate, String url, Object request, Class<?> responseType) {
        ResponseEntity<String> entity = restTemplate.postForEntity(url, request, String.class);
        return JSON.parseObject(entity.getBody(), (new TypeReference<Response<PageResult<T>>>(new Type[]{responseType}) {
        }).getType(), new Feature[0]);
    }

    public static <T> Response<List<T>> restList(RestTemplate restTemplate, String url, Object request, Class<?> responseType) {
        ResponseEntity<String> entity = restTemplate.postForEntity(url, request, String.class);
        return JSON.parseObject(entity.getBody(), (new TypeReference<Response<List<T>>>(new Type[]{responseType}) {
        }).getType(), new Feature[0]);
    }
}
