package com.cusc.nirvana.user.rnr.mg.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.RnrNoticeTemplateConfigDTO;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 消息模板配置(RnrNoticeTemplateConfig) client 
 *
 * @author yuy336
 * @since 2022-06-01 11:06:48
 */
@Component
public class RnrNoticeTemplateConfigClient {
   
    @Autowired
    @Qualifier("restTemplateRnrMg")
    RestTemplate restTemplateRnrMg;

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<RnrNoticeTemplateConfigDTO>> queryByPage(RnrNoticeTemplateConfigDTO bean) {
		return RnrMgRestTemplateUtils.postForResponsePageResult(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/rnrNoticeTemplateConfig/queryByPage", bean, RnrNoticeTemplateConfigDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<RnrNoticeTemplateConfigDTO> getByUuid(RnrNoticeTemplateConfigDTO bean) {
		return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL +  "/rnrNoticeTemplateConfig/getByUuid",
               bean,
                RnrNoticeTemplateConfigDTO.class);
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<RnrNoticeTemplateConfigDTO>> queryByList(RnrNoticeTemplateConfigDTO bean) {
		 return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/rnrNoticeTemplateConfig/queryByList", bean,
                RnrNoticeTemplateConfigDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response add(RnrNoticeTemplateConfigDTO bean) {
	   return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/rnrNoticeTemplateConfig/add", bean, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    public Response update(RnrNoticeTemplateConfigDTO bean) {
		return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/rnrNoticeTemplateConfig/update", bean, Response.class);
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<Boolean> deleteById(RnrNoticeTemplateConfigDTO bean) {
		return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/rnrNoticeTemplateConfig/deleteById", bean, Response.class);
    }
}
