package com.cusc.nirvana.user.rnr.mg.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.*;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

@Component
public class OrgSimRelClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    RestTemplate restTemplateRnrMg;

    /**
     * 新增组织与SIM卡关系
     * @param bean
     * @return
     */
    public Response<OrgSimRelDTO> add(OrgSimRelDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/orgSimRel/add", bean, OrgSimRelDTO.class);
    }

    /**
     * 批量新增组织与SIM卡的关系
     * @param bean
     * @return
     */
    public Response<?> addBatch(OrgSimRelBatchDTO bean) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/orgSimRel/addBatch", bean, Response.class);
    }

    /**
     * 修改组织与SIM卡关系
     * @param bean
     * @return
     */
    public Response<OrgSimRelDTO> update(OrgSimRelDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/orgSimRel/update", bean, OrgSimRelDTO.class);
    }

    /**
     * 修改sim卡与vin码绑定状态
     * @param simRelBindStatusDTO
     * @return
     */
    public Response<Boolean> updateBindStatus(OrgSimRelBindStatusDTO simRelBindStatusDTO) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/orgSimRel/updateBindStatus", simRelBindStatusDTO, Boolean.class);
    }

    /**
     * 修改sim卡与vin码绑定状态
     * @return
     */
    public Response<Boolean> updateBindIccid(List<String> iccid) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/orgSimRel/updateBindIccid", iccid, Boolean.class);
    }
    /**
     * 删除SIM卡导入历史信息
     * @param bean
     * @return
     */
    public Response delete(OrgSimRelDTO bean) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/orgSimRel/delete", bean, Response.class);
    }

    /**
     * 查询指定数据
     * @param uuid
     * @return
     */
    public Response<OrgSimRelDTO> getByUuid(String uuid) {
        return RnrMgRestTemplateUtils.getForResponse(restTemplateRnrMg,UserRnrMgClientConstant.USER_RNR_MG_URL + "/orgSimRel/getByUuid?uuid=" + uuid, OrgSimRelDTO.class);
    }

    /**
     * 根据Iccid查询卡信息
     * @param iccid
     * @return
     */
    public Response<OrgSimRelDTO> getByIccid(String iccid) {
        return RnrMgRestTemplateUtils.getForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/orgSimRel/getByIccid?iccid=" + iccid, OrgSimRelDTO.class);
    }

    /**
     * 根据vin码查询车卡关系列表
     * @param queryDTO
     * @return
     */
    public Response<List<OrgSimRelDTO>> queryByVin(OrgSimRelVinQueryDTO queryDTO) {
        return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/orgSimRel/queryByVin", queryDTO, OrgSimRelDTO.class);
    }

    /**
     * 分页查询历史数据
     * @param bean
     * @return
     */
    public Response<PageResult<OrgSimRelDTO>> queryByPage(OrgSimRelQueryDTO bean) {
        return RnrMgRestTemplateUtils.postForResponsePageResult(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/orgSimRel/queryByPage", bean, OrgSimRelDTO.class);
    }

    public Response<List<OrgSimRelDTO>> queryByList(IccIdListRequestDTO requestDTO) {
        return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/orgSimRel/queryByList", requestDTO, OrgSimRelDTO.class);
    }

    public Response updateVin(List<MgRnrCardInfoDTO> mgRnrCardInfoDTOList) {
        return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/orgSimRel/updateVin", mgRnrCardInfoDTOList, Response.class);
    }

}
