package com.cusc.nirvana.user.rnr.mg.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.MgTenantBizzConfigDTO;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 租户业务配置(MgTenantBizzConfig) client
 *
 * @author yuy336
 * @since 2022-06-14 09:32:58
 */
@Component
public class MgTenantBizzConfigClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    private RestTemplate restTemplateRnrMg;

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<MgTenantBizzConfigDTO>> queryByPage(MgTenantBizzConfigDTO bean) {
        return RnrMgRestTemplateUtils.postForResponsePageResult(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgTenantBizzConfig/queryByPage", bean,
                MgTenantBizzConfigDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<MgTenantBizzConfigDTO> getByUuid(MgTenantBizzConfigDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgTenantBizzConfig/getByUuid",
                bean,
                MgTenantBizzConfigDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<MgTenantBizzConfigDTO>> queryByList(MgTenantBizzConfigDTO bean) {
        return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgTenantBizzConfig/queryByList", bean,
                MgTenantBizzConfigDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response add(MgTenantBizzConfigDTO bean) {
        return RnrMgRestTemplateUtils.postForObject(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgTenantBizzConfig/add", bean, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    public Response update(MgTenantBizzConfigDTO bean) {
        return RnrMgRestTemplateUtils.postForObject(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgTenantBizzConfig/update", bean, Response.class);
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<Boolean> deleteById(MgTenantBizzConfigDTO bean) {
        return RnrMgRestTemplateUtils.postForObject(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgTenantBizzConfig/deleteById", bean, Response.class);
    }

    /**
     * 通过租户编码和组织查询业务配置
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<MgTenantBizzConfigDTO> getByTenantAndOrgan(MgTenantBizzConfigDTO bean) {
        //return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL +  "/mgSecretKey/getByTenantNoAndOrgan",
        //        bean, MgSecretKeyDTO.class);
        return null;
    }
}
