package com.cusc.nirvana.user.rnr.mg.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrLiaisonInfoDTO;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 实名联系人信息表(MgRnrLiaisonInfo) client 
 *
 * @author yuy336
 * @since 2022-03-03 19:59:18
 */
@Component
public class MgRnrLiaisonInfoClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    private RestTemplate restTemplateRnrMg;

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<MgRnrLiaisonInfoDTO>> queryByPage(MgRnrLiaisonInfoDTO bean) {
		return RnrMgRestTemplateUtils.postForResponsePageResult(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrLiaisonInfo/queryByPage", bean, MgRnrLiaisonInfoDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<MgRnrLiaisonInfoDTO> getByUuid(MgRnrLiaisonInfoDTO bean) {
		return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL +  "/mgRnrLiaisonInfo/getByUuid",
               bean,
                MgRnrLiaisonInfoDTO.class);
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<MgRnrLiaisonInfoDTO>> queryByList(MgRnrLiaisonInfoDTO bean) {
		 return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrLiaisonInfo/queryByList", bean,
                MgRnrLiaisonInfoDTO.class);
    }

    /**
     * 通过rnrid查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<MgRnrLiaisonInfoDTO> getByRnrid(MgRnrLiaisonInfoDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL +  "/mgRnrLiaisonInfo/getByRnrid",
                bean,
                MgRnrLiaisonInfoDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response add(MgRnrLiaisonInfoDTO bean) {
	   return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrLiaisonInfo/add", bean, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    public Response update(MgRnrLiaisonInfoDTO bean) {
		return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrLiaisonInfo/update", bean, Response.class);
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<Boolean> deleteById(MgRnrLiaisonInfoDTO bean) {
		return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrLiaisonInfo/deleteById", bean, Response.class);
    }
}
