package com.cusc.nirvana.user.rnr.mg.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCompanyInfoDTO;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 实名公司信息表(MgRnrCompanyInfo) client 
 *
 * @author yuy336
 * @since 2022-02-10 18:31:32
 */
@Component
public class MgRnrCompanyInfoClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    private RestTemplate restTemplateRnrMg;

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<MgRnrCompanyInfoDTO>> queryByPage(MgRnrCompanyInfoDTO bean) {
		return RnrMgRestTemplateUtils.postForResponsePageResult(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCompanyInfo/queryByPage", bean, MgRnrCompanyInfoDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<MgRnrCompanyInfoDTO> getByUuid(MgRnrCompanyInfoDTO bean) {
		return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL +  "/mgRnrCompanyInfo/getByUuid",
               bean,
                MgRnrCompanyInfoDTO.class);
    }

    /**
     * 通过rnrid查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<MgRnrCompanyInfoDTO> getByRnrid(MgRnrCompanyInfoDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL +  "/mgRnrCompanyInfo/getByRnrid",
                bean,
                MgRnrCompanyInfoDTO.class);
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<MgRnrCompanyInfoDTO>> queryByList(MgRnrCompanyInfoDTO bean) {
		 return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCompanyInfo/queryByList", bean,
                MgRnrCompanyInfoDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response add(MgRnrCompanyInfoDTO bean) {
	   return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCompanyInfo/add", bean, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    public Response update(MgRnrCompanyInfoDTO bean) {
		return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCompanyInfo/update", bean, Response.class);
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<Boolean> deleteById(MgRnrCompanyInfoDTO bean) {
		return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCompanyInfo/deleteById", bean, Response.class);
    }


    public Response<List<String>> findRnrIdsByCompanyName(MgRnrCompanyInfoDTO bean){
        return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg,UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrCompanyInfo/findRnrIdsByCompanyName", bean, String.class);
    }
}
