package com.cusc.nirvana.user.rnr.mg.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.MgCheckProgressDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgCheckStatisticsDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgCheckStatisticsQueryDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * @author hxin
 * @date 2022/5/18 15:48
 */
@Component
public class MgCheckProgressClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    private RestTemplate restTemplateRnrMg;

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<MgCheckProgressDTO>> queryByPage(MgCheckProgressDTO bean) {
        return RnrMgRestTemplateUtils.postForResponsePageResult(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgCheckProgress/queryByPage", bean, MgCheckProgressDTO.class);
    }

    /**
     * 查询前一天统计数据
     *
     * @return 查询结果
     */
    public Response<MgCheckStatisticsDTO> queryCheckStatistics(MgCheckStatisticsQueryDTO queryDTO) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgCheckProgress/queryCheckStatistics",queryDTO, MgCheckStatisticsDTO.class);
    }
}
