package com.cusc.nirvana.user.rnr.mg.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.*;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

/**
 * @author hxin
 * @date 2022/5/18 15:48
 */
@Component
public class LocalVerifyClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    private RestTemplate restTemplateRnrMg;

    /**
     * 本地审核列表
     *
     * @return 查询结果
     */
    public Response<PageResult> list(LocalVerifyListRqDTO rq) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/localverify/list", rq, PageResult.class);
    }

    /**
     * 企业负责人变更审核详情
     *
     * @param uuid
     * @return
     */
    public Response<CompanyCorporationChangeRespDTO> enterpriseRnrPersonDetail(String uuid) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/localverify/enterpriseRnrPersonDetail",
                uuid,
                CompanyCorporationChangeRespDTO.class);
    }

    /**
     * 查询工单企业详情
     *
     * @param rnrOrderDTO
     * @return
     */
    public Response<EnterpriseVerifyDetailDTO> getEnterpriseDetail(@RequestBody RnrOrderDTO rnrOrderDTO) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/localverify/getEnterpriseDetail", rnrOrderDTO, EnterpriseVerifyDetailDTO.class);
    }

    /**
     * 查询工单自然人详情
     *
     * @param rq
     * @return
     */
    public Response personDetail(@RequestBody LocalVerifyListRqDTO rq) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/localverify/personDetail", rq, Object.class);
    }

    /**
     * 工单审核
     *
     * @param rq
     * @return
     */
    public Response submit(@RequestBody LocalVerifySubmitRq rq) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/localverify/submit", rq, Object.class);
    }

    /**
     * 查询重试的数据
     * @param rq
     * @return
     */
    public Response<RnrRelationDTO> retry(@RequestBody LocalVerifySubmitRq rq) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/localverify/retry",
                rq, RnrRelationDTO.class);
    }

    /**
     * 工单审核
     *
     * @param rq
     * @return
     */
    public Response validationRnrOrder(@RequestBody LocalVerifySubmitRq rq) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/localverify/validationRnrOrder", rq, Object.class);
    }

}
