package com.cusc.nirvana.user.rnr.common.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * Description: resttemplate的连接池配置
 * <br />
 * CreateDate 2022-05-18 15:00
 *
 * @author yuy336
 **/
@Component
@Data
public class RnrMgHttpPoolConfig {

    /**
     * 设置整个连接池最大连接数
     */
    @Value("${httpPool.rnrMg.maxTotal:200}")
    private Integer maxTotal;

    /**
     * 路由是对maxTotal的细分,针对一个url的最大并发数,每路由最大连接数，默认值是2
     */
    @Value("${httpPool.rnrMg.defaultMaxPerRoute:100}")
    private Integer defaultMaxPerRoute;

    /**
     * 服务器返回数据(response)的时间，超过该时间抛出read timeout
     */
    @Value("${httpPool.rnrMg.socketTimeout:10000}")
    private Integer socketTimeout;

    /**
     * 连接上服务器(握手成功)的时间，超出该时间抛出connect timeout
     */
    @Value("${httpPool.rnrMg.connectTimeout:1000}")
    private Integer connectTimeout;

    /**
     * 从连接池中获取连接的超时时间，超过该时间未拿到可用连接，会抛出org.apache.http.conn.ConnectionPoolTimeoutException: Timeout waiting for connection from pool
     */
    @Value("${httpPool.rnrMg.connectionRequestTimeout:500}")
    private Integer connectionRequestTimeout;

    /**
     * 线程最大空闲时间
     */
    @Value("${httpPool.rnrMg.maxIdleTime:10}")
    private Integer maxIdleTime;
}
