package com.cusc.nirvana.user.rnr.mg.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 实名工单信息(RnrOrder) client
 *
 * @author yuy336
 * @since 2022-01-26 13:39:49
 */
@Component
public class RnrOrderClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    private RestTemplate restTemplateRnrMg;

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<RnrOrderDTO>> queryByPage(RnrOrderDTO bean) {
        return RnrMgRestTemplateUtils.postForResponsePageResult(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrOrder/queryByPage", bean, RnrOrderDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<RnrOrderDTO> getByUuid(RnrOrderDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrOrder/getByUuid",
               bean,
                RnrOrderDTO.class);
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<RnrOrderDTO>> queryByList(RnrOrderDTO bean) {
        return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrOrder/queryByList", bean,
                RnrOrderDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response add(RnrOrderDTO bean) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrOrder/add", bean, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    public Response update(RnrOrderDTO bean) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrOrder/update", bean, Response.class);
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<Boolean> deleteById(RnrOrderDTO bean) {
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrOrder/deleteById", bean, Response.class);
    }

	/**
	 * 发起一个工单审批
	 * @param dto
	 * @return
	 */
	public Response startWorkOrder(@RequestBody RnrOrderDTO dto){
		return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrOrder/startWorkOrder", dto, Response.class);
	}

    /**
     * 更新工单状态
     * @param dto
     * @return
     */
    public Response updateOrderStatus(@RequestBody RnrOrderDTO dto){
        return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrOrder/updateOrderStatus", dto, Response.class);
    }
}
