package com.cusc.nirvana.user.rnr.mg.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.OpenTenantRelationDTO;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 开放平台租户和实名制租户映射关系表(OpenTenantRelation) client
 *
 * @author yuy336
 * @since 2022-06-15 20:03:19
 */
@Component
public class OpenTenantRelationClient {
    @Autowired
    @Qualifier("restTemplateRnrMg")
    private RestTemplate restTemplateRnrMg;

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<OpenTenantRelationDTO>> queryByPage(OpenTenantRelationDTO bean) {
        return RnrMgRestTemplateUtils.postForResponsePageResult(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/openTenantRelation/queryByPage", bean,
                OpenTenantRelationDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<OpenTenantRelationDTO> getByUuid(OpenTenantRelationDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/openTenantRelation/getByUuid",
                bean,
                OpenTenantRelationDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<OpenTenantRelationDTO>> queryByList(OpenTenantRelationDTO bean) {
        return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/openTenantRelation/queryByList", bean,
                OpenTenantRelationDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response add(OpenTenantRelationDTO bean) {
        return RnrMgRestTemplateUtils.postForObject(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/openTenantRelation/add", bean, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    public Response update(OpenTenantRelationDTO bean) {
        return RnrMgRestTemplateUtils.postForObject(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/openTenantRelation/update", bean, Response.class);
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<Boolean> deleteById(OpenTenantRelationDTO bean) {
        return RnrMgRestTemplateUtils.postForObject(restTemplateRnrMg,
                UserRnrMgClientConstant.USER_RNR_MG_URL + "/openTenantRelation/deleteById", bean, Response.class);
    }
}
