package com.cusc.nirvana.user.rnr.mg.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.MgVehicleCompanyDTO;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 车企信息表(FpVehicleCompany) client 
 *
 * @author yuy336
 * @since 2022-04-19 20:11:23
 */
@Component
public class MgVehicleCompanyClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    private RestTemplate restTemplateRnrMg;

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<MgVehicleCompanyDTO>> queryByPage(MgVehicleCompanyDTO bean) {
		return RnrMgRestTemplateUtils.postForResponsePageResult(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgVehicleCompany/queryByPage", bean, MgVehicleCompanyDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<MgVehicleCompanyDTO> getByUuid(MgVehicleCompanyDTO bean) {
		return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL +  "/mgVehicleCompany/getByUuid",
               bean,
                MgVehicleCompanyDTO.class);
    }

    /**
     * 通过租户编号查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<MgVehicleCompanyDTO> getVehicleCompany(MgVehicleCompanyDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL +  "/mgVehicleCompany/getVehicleCompany",
                bean, MgVehicleCompanyDTO.class);
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<MgVehicleCompanyDTO>> queryByList(MgVehicleCompanyDTO bean) {
		 return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgVehicleCompany/queryByList", bean,
                MgVehicleCompanyDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response add(MgVehicleCompanyDTO bean) {
	   return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgVehicleCompany/add", bean, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    public Response update(MgVehicleCompanyDTO bean) {
		return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgVehicleCompany/update", bean, Response.class);
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<Boolean> deleteById(MgVehicleCompanyDTO bean) {
		return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgVehicleCompany/deleteById", bean, Response.class);
    }
}
