package com.cusc.nirvana.user.rnr.mg.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.MgSecretKeyDTO;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 实名密钥管理(MgSecretKey) client 
 *
 * @author yuy336
 * @since 2022-06-01 11:05:53
 */
@Component
public class MgSecretKeyClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    private RestTemplate restTemplateRnrMg;

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<MgSecretKeyDTO>> queryByPage(MgSecretKeyDTO bean) {
		return RnrMgRestTemplateUtils.postForResponsePageResult(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgSecretKey/queryByPage", bean, MgSecretKeyDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<MgSecretKeyDTO> getByUuid(MgSecretKeyDTO bean) {
		return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL +  "/mgSecretKey/getByUuid",
               bean,
                MgSecretKeyDTO.class);
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<MgSecretKeyDTO>> queryByList(MgSecretKeyDTO bean) {
		 return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgSecretKey/queryByList", bean,
                MgSecretKeyDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response add(MgSecretKeyDTO bean) {
	   return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgSecretKey/add", bean, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    public Response update(MgSecretKeyDTO bean) {
		return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgSecretKey/update", bean, Response.class);
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<Boolean> deleteById(MgSecretKeyDTO bean) {
		return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgSecretKey/deleteById", bean, Response.class);
    }

    /**
     * 通过租户编码和组织查询密钥
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<MgSecretKeyDTO> getByTenantNoAndOrgan(MgSecretKeyDTO bean) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL +  "/mgSecretKey/getByTenantNoAndOrgan",
                bean, MgSecretKeyDTO.class);
    }
}
