package com.cusc.nirvana.user.rnr.mg.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.UserRnrMgClientConstant;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 实名信息表(MgRnrInfo) client 
 *
 * @author yuy336
 * @since 2022-02-10 18:31:08
 */
@Component
public class MgRnrInfoClient {

    @Autowired
    @Qualifier("restTemplateRnrMg")
    private RestTemplate restTemplateRnrMg;
    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<MgRnrInfoDTO>> queryByPage(MgRnrInfoDTO bean) {
		return RnrMgRestTemplateUtils.postForResponsePageResult(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrInfo/queryByPage", bean, MgRnrInfoDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<MgRnrInfoDTO> getByUuid(MgRnrInfoDTO bean) {
		return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL +  "/mgRnrInfo/getByUuid",
               bean,
                MgRnrInfoDTO.class);
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<MgRnrInfoDTO>> queryByList(MgRnrInfoDTO bean) {
		 return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrMg, UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrInfo/queryByList", bean,
                MgRnrInfoDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response add(MgRnrInfoDTO bean) {
	   return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrInfo/add", bean, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    public Response update(MgRnrInfoDTO bean) {
		return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrInfo/update", bean, Response.class);
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<Boolean> deleteById(MgRnrInfoDTO bean) {
		return restTemplateRnrMg.postForObject(UserRnrMgClientConstant.USER_RNR_MG_URL + "/mgRnrInfo/deleteById", bean, Response.class);
    }
}
