package com.cusc.nirvana.user.rnr.mg.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class SimVehicleDTO {

    /**vin码*/
    @ApiModelProperty(value = "VIN码", required = true)
    @NotBlank(message = "VIN码不能为空")
    private String vin;

    /**ICCID*/
    @ApiModelProperty(value = "iccid", required = true)
    @NotBlank(message = "iccid不能为空")
    private String iccid;

    @ApiModelProperty(value = "msisdn")
    private String msisdn;

    @ApiModelProperty(value = "imsi")
    private String imsi;

    @ApiModelProperty(value = "ip")
    private String ip;

    @ApiModelProperty(value = "是否允许车主自己实名")
    private Boolean realBySelf = false;

    /**失败原因*/
    @ApiModelProperty(value = "返回的错误信息，作为入参时不需要传递")
    private String failReason;

    @ApiModelProperty(value = "绑定关系 0-已绑定；1-已解绑")
    private Integer bindingStatus;

    @ApiModelProperty(value = "运营商类型")
    private String mbCode;
}
