package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

@ApiModel(value = "SimFileHistoryQueryDTO对象", description = "查询参数对象")
@Data
public class SimFileHistoryQueryDTO extends BaseRnrMgPageDTO {

    /**组织uuid*/
    @ApiModelProperty(value = "组织uuid, 为必填项", required = true)
    @NotNull(message = "组织uuid不能为空")
    private String orgUuid;

    @ApiModelProperty(value = "文件类型,0:sim卡,1:车卡关系", required = true)
//    @NotNull(message = "文件类型不能为空")
    private Integer fileType;

    /**处理结果*/
    @ApiModelProperty(value = "处理结果,0-导入中 1-导入成功 2-错误", required = true)
    private Integer status;

    /**查询开始时间*/
    @ApiModelProperty(value = "查询开始时间，非必填", required = false)
    private Date startCreateTime;

    /**查询结束时间*/
    @ApiModelProperty(value = "查询结束时间, 非必填", required = false)
    private Date endCreateTime;

}
