package com.cusc.nirvana.user.rnr.mg.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.cusc.nirvana.user.rnr.mg.validation.group.Delete;
import com.cusc.nirvana.user.rnr.mg.validation.group.Insert;
import com.cusc.nirvana.user.rnr.mg.validation.group.Update;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * Sim卡、车卡关系文件导入历史对象
 *
 * @author yuy336
 * @since 2022-04-19 20:11:15
 */
@ApiModel(value = "SimFileHistoryDTO对象", description = "")
@Data
public class SimFileHistoryDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 业务UUID
     */
    @ApiModelProperty(value = "业务UUID", example = "10000")
    @NotNull(message = "业务uuid不能为空", groups = Update.class)
    @Length(message = "业务uuid长度不能大于32", max = 32, groups = {Update.class, Delete.class})
    private String uuid;

    /**
     * 组织业务ID
     */
    @ApiModelProperty(value = "组织ID", example = "1001")
    @NotNull(message = "组织业务uuid不能为空", groups = {Insert.class, Update.class, Delete.class})
    private String orgUuid;

    /**
     * 文件名称
     */
    @ApiModelProperty(value = "文件名称", example = "文件名称")
    @NotNull(message = "文件名称不能为空", groups = {Insert.class, Update.class})
    @Length(message = "文件名长度不能大于100", max = 100, groups = {Insert.class, Update.class})
    private String fileName;

    /**
     * 是否校验通过
     */
    @ApiModelProperty(value = "是否校验通过", example = "1")
    @NotNull(message = "是否通过校验不能为空", groups = {Insert.class, Update.class})
    private Integer verification;

    /**
     * 异常信息
     */
    @ApiModelProperty(value = "异常信息", example = "异常信息")
    private String errorInfo;

    /**
     * 批次
     */
    @ApiModelProperty(value = "批次", example = "批次")
    private String batchNo;

    /**
     * 总行数
     */
    @ApiModelProperty(value = "总行数", example = "1")
    private Integer totalCount;

    /**
     * 错误行数
     */
    @ApiModelProperty(value = "错误行数", example = "1")
    private Integer errorCount;

    /**
     * 0-导入中 1-导入成功
     */
    @ApiModelProperty(value = "处理结果,0-导入中 1-导入成功 2-错误", example = "1")
    private Integer status;

    /**
     * 文件类型，0:sim卡, 1:车卡关系
     */
    @ApiModelProperty(value = "文件类型，0:sim卡, 1:车卡关系", example = "1")
    @NotNull(message = "文件类型不能为空", groups = {Insert.class, Update.class})
    private Integer fileType;

    /**
     * 文件存储地址
     */
    @ApiModelProperty(value = "文件存储地址", example = "文件存储地址")
    private String fileAddr;

    /**
     * 导入错误文件地址
     */
    @ApiModelProperty(value = "错误信息文件地址")
    private String errorFileAddr;

    /**导入方式,0-新增 1-修改*/
    @ApiModelProperty(value = "导入方式,0-新增 1-修改", example = "文件存储地址")
    private Integer importType;

    /**
     * 业务描述
     */
    @ApiModelProperty(value = "业务描述", example = "业务描述")
    private String description;

    @ApiModelProperty(value = "是否删除，0:未删除，1:已删除", example = "0")
    private Integer isDelete;

    @ApiModelProperty(value = "创建时间", example = "2022-01-01 00:00:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty(value = "创建时间", example = "2022-01-01 00:00:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty(value = "创建人", example = "zhangshan")
    private String creator;

}
