package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgPageDTO;
import com.cusc.nirvana.user.rnr.mg.constants.RnrResponseCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 实名工单信息(MgRnrOrder)传输对象类
 *
 * @author yuy336
 * @since 2022-01-26 13:38:31
 */
@ApiModel(value = "实名工单信息", description = "实名工单信息")
@Data
public class RnrOrderDTO extends BaseRnrMgPageDTO {

    private static final long serialVersionUID = 191679603133132959L;

    private static final String ORDER_TYPE_ERROR = RnrResponseCode.CERT_TYPE_ERROR.getDescription();

    @ApiModelProperty(value = "业务主键")
    private String uuid;

    @ApiModelProperty(value = "应用id")
    private String applicationId;
    @ApiModelProperty(value = "审核用户id")
    private String userId;

    @ApiModelProperty(value = "工单类型")
//    @NotNull(groups = SaveRelation.class, message = "工单类型不能为空")
//    @EnumValue(groups = SaveRelation.class, message = "工单类型错误", intValues = {0, 1, 2, 3, 4, 5, 6, 7})
    private Integer orderType;

    @ApiModelProperty(value = "实名id")
//    @NotBlank(groups = SaveRelation.class, message = "实名id不能为空")
    private String rnrId;

    @ApiModelProperty(value = "审核类型,0为自动,1为手动")
//    @NotNull(groups = SaveRelation.class, message = "审核类型不能为空")
    private Integer auditType;

    @ApiModelProperty(value = "工单来源")
//    @NotBlank(groups = SaveRelation.class, message = "工单来源不能为空")
    private String orderSource;

    @ApiModelProperty(value = "工单状态 0 待分派/认领，1 待审核，2 审核通过，3 未通过，4  已分配，5 已认领，6 解绑成功，7 解绑失败，8 重绑成功，9 超过24小时关卡; 具体枚举值参考：OrderStatus")
//    @NotNull(groups = SaveRelation.class, message = "工单状态不能为空")
//    @EnumValue(groups = SaveRelation.class, message = "工单状态错误", intValues = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9})
    private Integer orderStatus;

    @ApiModelProperty(value = "是否批量订单，参考枚举：ORDER_BATCH。0 不是，1是")
    private Integer isBatchOrder;

    @ApiModelProperty(value = "三方系统流水号")
//    @NotBlank(groups = SaveRelation.class, message = "三方系统流水号不能为空")
    private String serialNumber;

    @ApiModelProperty(value = "审批编号，工单系统流水号")
//    @NotBlank(groups = SaveRelation.class, message = "审批编号不能为空")
    private String approvalNo;

    @ApiModelProperty(value = "分派时间")
    private Date allocateTime;

    @ApiModelProperty(value = "审核时间")
    private Date auditTime;

    @ApiModelProperty(value = "最终审批时间")
    private Date finalApproveTime;

    @ApiModelProperty(value = "更新码")
    private Integer updatedCode;

    @ApiModelProperty(value = "评审意见")
    private String verifyComments;

    @ApiModelProperty(value = "备注信息")
    private String comment;

    @ApiModelProperty(value = "业务区分")
    private String channelId;

    @ApiModelProperty(value = "租户编号")
    private String tenantNo;

    @ApiModelProperty(value = "分表路由键")
    private Long routingKey;

    @ApiModelProperty(value = "最后一次操作人")
    private String operator;

    @ApiModelProperty(value = "是否是自动实名")
    private boolean autoRnr;


    @ApiModelProperty(value = "订单延迟配置")
    private String orderDelay;

    @ApiModelProperty(value = "老状态")
    private Integer oldOrderStatus;

	@ApiModelProperty(value = "是否发送工单系统")
    private Boolean sendWorkOrder;

    @ApiModelProperty(value = "组织id")
    private String orgId;

    @ApiModelProperty(value = "业务类型：1 实名, 2 解绑, 3 换件,  4 信息变更,5 重绑")
    private Integer rnrBizzType;

	@ApiModelProperty("创建时间查询开始")
	private Date createTimeQueryStart;

	@ApiModelProperty("创建时间查询结束")
	private Date createTimeQueryEnd;

	private List<String> uuidList;

	private List<String> rnrIdList;

	/**
	 * 审核人
	 */
	private String reviewUserId;
    /** 审核人 */
    private List<String> reviewUserIds;
    /** 组织ID */
    private List<String> orgIdList;
    /** 审核日期开始 */
    private Date beginAuditTime;
    /** 审核日期结束 */
    private Date endAuditTime;
}

