package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 消息模板配置(RnrNoticeTemplateConfig)传输对象类
 *
 * @author yuy336
 * @since 2022-06-01 11:05:30
 */
@ApiModel(value = "消息模板配置", description = "消息模板配置")
@Data
public class RnrNoticeTemplateConfigDTO extends BaseRnrMgPageDTO {

    private static final long serialVersionUID = 733623188788035690L;
    
    @ApiModelProperty(value = "业务类型：1 实名, 2 解绑, 3 换件,  4 信息变更,5 重绑")
    private Integer rnrBizzType;
    
    @ApiModelProperty(value = "通知方式：短信、邮箱、webhook")
    private Integer noticeWay;
    
    @ApiModelProperty(value = "标签code")
    private String tagcode;
    
    @ApiModelProperty(value = "模板编号")
    private String templateCode;
    
    @ApiModelProperty(value = "模板内容")
    private String templateContent;
    
    @ApiModelProperty(value = "语言版本")
    private String lang;
    
    @ApiModelProperty(value = "组织id")
    private String orgId;
    
    @ApiModelProperty(value = "租户编号")
    private String tenantNo;
    
    @ApiModelProperty(value = "最后一次操作人")
    private String operator;
}

