package com.cusc.nirvana.user.rnr.mg.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.cusc.nirvana.user.rnr.mg.validation.group.Delete;
import com.cusc.nirvana.user.rnr.mg.validation.group.Insert;
import com.cusc.nirvana.user.rnr.mg.validation.group.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

@ApiModel(value = "OrgSimRelDTO对象", description = "")
@Data
public class OrgSimRelDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "业务UUID", example = "10000")
    @NotNull(message = "业务uuid不能为空", groups = {Update.class, Delete.class})
    private String uuid;

    @ApiModelProperty(value = "组织业务UUID", example = "10000")
    @NotNull(message = "组织业务UUID不能为空", groups = {Insert.class, Update.class, Delete.class})
    private String orgUuid;

    @ApiModelProperty(value = "SIM卡的iccid")
    @NotNull(message = "iccid不能为空", groups = {Insert.class})
    private String iccid;

    /**VIN码*/
    @ApiModelProperty(value = "VIN码")
    private String vin;

    /**imsi码*/
    @ApiModelProperty(value = "IMSI码")
    private String imsi;

    @ApiModelProperty(value = "租户编码")
    private String tenantNo;

    /**msisdn码*/
    @ApiModelProperty(value = "MSISDN编码")
    @NotNull(message = "msisdn不能为空", groups = {Insert.class, Update.class})
    private String msisdn;

    /**ip地址*/
    @ApiModelProperty(value = "sim卡IP地址")
    private String ip;

    /**绑定状态*/
    @ApiModelProperty(value = "绑定状态")
    private Integer bindStatus;

    /**sim卡运营服务商*/
    @ApiModelProperty(value = "sim卡所属运营服务商")
    private String serviceProvider;

    /**出厂年份*/
    @ApiModelProperty(value = "出厂年份")
    private Integer years;

    /**品牌编码*/
    @ApiModelProperty(value = "sim卡所安装的品牌编码")
    private String brand;

    @ApiModelProperty(value = "sim卡所安装的品牌名称")
    private String brandName;

    /**车型编码*/
    @ApiModelProperty(value = "sim卡所安装的车型编码")
    private String vehicleModel;

    /**车型名称*/
    @ApiModelProperty(value = "sim卡所安装的车型名称")
    private String vehicleModelName;

    /**车系编码*/
    @ApiModelProperty(value = "sim卡所安装的车系编码")
    private String vehicleSeries;

    /**车系名称*/
    @ApiModelProperty(value = "sim卡所安装的车系名称")
    private String vehicleSeriesName;

    /**sim卡安装位置*/
    @ApiModelProperty(value = "sim卡所安装在的位置")
    private String installLocation;

    @ApiModelProperty(value = "业务标签uuid")
    private String tagUuid;

    @ApiModelProperty(value = "是否允许车主自己实名")
    private Boolean realBySelf;

    @ApiModelProperty(value = "是否删除, 0:否, 1:是")
    private Integer isDelete = 0;

    @ApiModelProperty(value = "创建时间")
//    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty(value = "修改时间")
//    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty(value = "创建人")
    private String creator;

    @ApiModelProperty("车企名录")
    private String companyCode;

}
