package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 实名公司信息表(MgRnrCompanyInfo)传输对象类
 *
 * @author yuy336
 * @since 2022-02-14 14:39:36
 */
@ApiModel(value = "实名公司信息表", description = "实名公司信息表")
@Data
public class MgRnrCompanyInfoDTO extends BaseRnrMgDTO {

    private static final long serialVersionUID = 308383184801280441L;
    
    @ApiModelProperty(value = "业务主键")
    private String uuid;

    @ApiModelProperty(value = "实名业务主键")
    private String rnrId;
    
    @ApiModelProperty(value = "企业名称")
    private String companyName;
    
    @ApiModelProperty(value = "证件类型")
    private String companyCertType;
    
    @ApiModelProperty(value = "证件号码")
    private String companyCertNumber;
    
    @ApiModelProperty(value = "证件地址")
    private String companyCertAddress;
    
    @ApiModelProperty(value = "企业通讯地址")
    private String companyContactAddress;
    
    @ApiModelProperty(value = "公司类型")
    private String companyType;
    
    @ApiModelProperty(value = "产业类型")
    private String industryType;
    
    @ApiModelProperty(value = "租户编号")
    private String tenantNo;
    
    @ApiModelProperty(value = "分表路由键")
    private Long routingKey;

	@ApiModelProperty(value = "是否车企实名 0 否 1是")
    private Integer isVehicleCompany;
    
    @ApiModelProperty(value = "最后一次操作人")
    private String operator;

    @ApiModelProperty(value = "业务类型：1 实名, 2 解绑, 3 换件,  4 信息变更,5 重绑")
    private Integer rnrBizzType;

	private List<String> rnrIdList;
}

