package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.constants.RnrRetCodeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Description: api端实名响应DTO
 * <br />
 * CreateDate 2022-03-01 14:38:21
 *
 * @author yuyi
 **/
@ApiModel(value = "实时认证")
public class ApiRnrRespDTO {

    /**
     * 认证结果码
     */
    private String code;

    /**
     * 认证结果信息
     */
    private String message;

    public static ApiRnrRespDTO getRnrResponse(RnrRetCodeEnum code) {
        ApiRnrRespDTO rnrResponse = new ApiRnrRespDTO();
        rnrResponse.setCode(code.getStringKey());
        rnrResponse.setMessage(code.getValue());
        return rnrResponse;
    }

    public static ApiRnrRespDTO createResponse(String code, String message) {
        ApiRnrRespDTO rnrResponse = new ApiRnrRespDTO();
        rnrResponse.setCode(code);
        rnrResponse.setMessage(message);
        return rnrResponse;
    }

    public static ApiRnrRespDTO createResponse(Integer code, String message) {
        return createResponse(String.valueOf(code), message);
    }

    @ApiModelProperty(value = "认证结果码")
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @ApiModelProperty(value = "认证结果信息")
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

}
