package com.cusc.nirvana.user.rnr.mg.dto;

import java.io.Serializable;
import java.util.List;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "换件信息", description = "换件信息")
@Data
public class ApiMgRnrCardInfoChangeDTO implements Serializable {

    @ApiModelProperty(value = "请求流水号")
    @NotBlank(message = "请求流水号不能为空")
    private String serialNumber;

    @ApiModelProperty(value = "组织ID")
    @NotBlank(message = "组织ID不能为空")
    private String orgId;

    @ApiModelProperty(value = "新车联网卡")
    @NotBlank(message = "新车联网卡不能为空")
    private String newMsisdn;

    @ApiModelProperty(value = "新车联网卡ICCID")
    @NotBlank(message = "新车联网卡ICCID不能为空")
    private String newIccid;

    @ApiModelProperty(value = "老车联网卡MSISDN")
    private String oldMsisdn;

    @ApiModelProperty(value = "老车联网卡ICCID")
    @NotBlank(message = "老车联网卡ICCID不能为空")
    private String oldIccid;

    @ApiModelProperty(value = "sim卡所属运营服务商")
    @NotBlank(message = "sim卡所属运营服务商不能为空")
    private String serviceProvider;

    @ApiModelProperty(value = "道路机动 车辆生产企业名称")
    @NotBlank(message = "道路机动 车辆生产企业名称不能为空")
    private String nameVehicleEnterprise;

    @ApiModelProperty(value = "车辆识别代号或车架号")
    @NotBlank(message = "车辆识别代号或车架号不能为空")
    private String vin;

    @ApiModelProperty(value = "车辆类型（1表示乘用车及客车，2表示货车，3表 示半挂车牵引车，4表示半挂车，5表示 - 12 - 两轮摩托车和两轮轻便摩托车，6表示 三轮摩托车和三轮轻便摩托车，7表示 三轮汽车，8表示低速货车，9表示专用 汽车，10表示非《公告》车辆产品。）")
    @NotBlank(message = "车辆类型不能为空")
    private String vehicleType;

    @ApiModelProperty(value = "车辆产地")
    @NotBlank(message = "车辆产地不能为空")
    private String placeOfOriginOfVehicle;

    @ApiModelProperty(value = "车辆品牌")
    @NotBlank(message = "车辆品牌不能为空")
    private String vehicleDepartment;

    @ApiModelProperty(value = "车辆状态")
    @NotBlank(message = "车辆状态不能为空")
    private String vehicleStatus;

    @ApiModelProperty(value = "状态变更时间")
    private String statusUpdateTime;

    @ApiModelProperty(value = "受理时间")
    private String acceptTime;

    @ApiModelProperty(value = "车辆名称")
    @NotEmpty(message = "车辆名称不能为空")
    private String vehicleName;

    @ApiModelProperty(value = "车辆型号")
    @NotEmpty(message = "车辆型号不能为空")
    private String vehicleNum;


    @ApiModelProperty(value = "车型通用名称")
    @NotBlank(message = "车型通用名称不能为空")
    private String vehicleModel;

    @ApiModelProperty(value = "车身颜色")
    @NotBlank(message = "车身颜色不能为空")
    private String bodyColor;

    @ApiModelProperty(value = "燃料种类")
    @NotBlank(message = "燃料种类不能为空")
    private String fuelType;

    @ApiModelProperty(value = "发动机号码")
    private String engineNum;

    @ApiModelProperty(value = "电动机序列号")
    private String motorNum;

    @ApiModelProperty(value = "车辆出厂时间")
    @NotBlank(message = "车辆出厂时间不能为空")
    private String vehicleDepartureTime;

    @ApiModelProperty(value = "车辆销售时间")
    private String vehicleSalesTime;

    @ApiModelProperty(value = "车辆销售信息变更时间")
    private String vehicleSalesUpdateTime;

    @ApiModelProperty(value = "车牌号码")
    private String licensePlateNumber;

    @ApiModelProperty(value = "车辆销售 渠道名称")
    private String vehicleChannelName;

    @ApiModelProperty(value = "车辆销售渠道类型")
    private String vehicleChannelType;

    @ApiModelProperty(value = "车辆销售渠道员工姓名")
    private String vehicleStaffName;

    @ApiModelProperty(value = "车辆销售渠道地址")
    private String vehicleLogginAddress;

    @ApiModelProperty(value = "Vin和ICCID是否存在")
    private Boolean checkResult;

    @ApiModelProperty(value = "v是否已实名")
    private Boolean checkV;


    @ApiModelProperty(value = "mgRnrCardInfoId")
    private Long mgRnrCardInfoId;
    /** 创建人 */
    private String creator;
    /** sim卡类型
     * MOSC 4G#FAW-VW 表示一汽大众（MOSC4G）
     * MOSC 4G#FAW-AUDI 表示一汽奥迪(MOSC4)
     * MQB 5G#FAW-VW 表示ConMod5 MQB 一汽大众
     * MEB 5G#FAW-VW 表示ConMod5 MEB一汽大众
     */
    private String simType;


}
